/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.impl.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.puffish.skillsmod.api.json.JsonArrayWrapper;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonMapReader;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.impl.json.JsonElementWrapperImpl;
import net.puffish.skillsmod.impl.json.JsonWrapperImpl;

public class JsonObjectWrapperImpl
extends JsonWrapperImpl
implements JsonObjectWrapper {
    private final JsonObject json;

    public JsonObjectWrapperImpl(JsonObject json, JsonPath path) {
        super(path);
        this.json = json;
    }

    @Override
    public Result<JsonElementWrapper, Failure> get(String key) {
        JsonPath newPath = this.path.thenObject(key);
        JsonElement element = this.json.get(key);
        if (element == null) {
            return Result.failure(newPath.expectedToExist());
        }
        return Result.success(new JsonElementWrapperImpl(element, newPath));
    }

    @Override
    public Result<JsonObjectWrapper, Failure> getObject(String key) {
        return this.get(key).mapFailure(e -> this.path.thenObject(key).expectedToExistAndBe("an object")).andThen(JsonElementWrapper::getAsObject);
    }

    @Override
    public Result<JsonArrayWrapper, Failure> getArray(String key) {
        return this.get(key).mapFailure(e -> this.path.thenObject(key).expectedToExistAndBe("an array")).andThen(JsonElementWrapper::getAsArray);
    }

    @Override
    public Result<String, Failure> getString(String key) {
        return this.get(key).mapFailure(e -> this.path.thenObject(key).expectedToExistAndBe("a string")).andThen(JsonElementWrapper::getAsString);
    }

    @Override
    public Result<Float, Failure> getFloat(String key) {
        return this.get(key).mapFailure(e -> this.path.thenObject(key).expectedToExistAndBe("a float")).andThen(JsonElementWrapper::getAsFloat);
    }

    @Override
    public Result<Double, Failure> getDouble(String key) {
        return this.get(key).mapFailure(e -> this.path.thenObject(key).expectedToExistAndBe("a double")).andThen(JsonElementWrapper::getAsDouble);
    }

    @Override
    public Result<Integer, Failure> getInt(String key) {
        return this.get(key).mapFailure(e -> this.path.thenObject(key).expectedToExistAndBe("an int")).andThen(JsonElementWrapper::getAsInt);
    }

    @Override
    public Result<Boolean, Failure> getBoolean(String key) {
        return this.get(key).mapFailure(e -> this.path.thenObject(key).expectedToExistAndBe("a boolean")).andThen(JsonElementWrapper::getAsBoolean);
    }

    @Override
    public Stream<Map.Entry<String, JsonElementWrapper>> stream() {
        return this.json.asMap().entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), new JsonElementWrapperImpl((JsonElement)entry.getValue(), this.path.thenObject((String)entry.getKey()))));
    }

    @Override
    public <S, F> Result<Map<String, S>, Map<String, F>> getAsMap(JsonMapReader<S, F> reader) {
        HashMap successMap = new HashMap();
        HashMap failureMap = new HashMap();
        this.json.asMap().forEach((key, value) -> ((Result)reader.apply(key, new JsonElementWrapperImpl((JsonElement)value, this.path.thenObject((String)key)))).peek(t -> successMap.put(key, t), t -> failureMap.put(key, t)));
        if (failureMap.isEmpty()) {
            return Result.success(successMap);
        }
        return Result.failure(failureMap);
    }

    @Override
    public JsonObject getJson() {
        return this.json;
    }
}

