/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.impl;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.api.Experience;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.impl.ExperienceImpl;
import net.puffish.skillsmod.impl.SkillImpl;

public class CategoryImpl
implements Category {
    private final ResourceLocation categoryId;

    public CategoryImpl(ResourceLocation categoryId) {
        this.categoryId = categoryId;
    }

    @Override
    public ResourceLocation getId() {
        return this.categoryId;
    }

    @Override
    public Optional<Experience> getExperience() {
        if (SkillsMod.getInstance().hasExperience(this.categoryId).orElseThrow().booleanValue()) {
            return Optional.of(new ExperienceImpl(this.categoryId));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Skill> getSkill(String skillId) {
        if (SkillsMod.getInstance().hasSkill(this.categoryId, skillId)) {
            return Optional.of(new SkillImpl(this, skillId));
        }
        return Optional.empty();
    }

    @Override
    public List<Skill> getSkills() {
        return SkillsMod.getInstance().getSkills(this.categoryId).orElseThrow().stream().map(skillId -> new SkillImpl(this, (String)skillId)).toList();
    }

    @Override
    public Collection<Skill> getUnlockedSkills(ServerPlayer player) {
        return SkillsMod.getInstance().getUnlockedSkills(player, this.categoryId).orElseThrow().stream().map(skillId -> new SkillImpl(this, (String)skillId)).toList();
    }

    @Override
    public void openScreen(ServerPlayer player) {
        SkillsMod.getInstance().openScreen(player, Optional.of(this.categoryId));
    }

    @Override
    public void unlock(ServerPlayer player) {
        SkillsMod.getInstance().unlockCategory(player, this.categoryId);
    }

    @Override
    public void lock(ServerPlayer player) {
        SkillsMod.getInstance().lockCategory(player, this.categoryId);
    }

    @Override
    public void erase(ServerPlayer player) {
        SkillsMod.getInstance().eraseCategory(player, this.categoryId);
    }

    @Override
    public void resetSkills(ServerPlayer player) {
        SkillsMod.getInstance().resetSkills(player, this.categoryId);
    }

    @Override
    public int getExtraPoints(ServerPlayer player) {
        return SkillsMod.getInstance().getExtraPoints(player, this.categoryId).orElseThrow();
    }

    @Override
    public void setExtraPoints(ServerPlayer player, int count) {
        SkillsMod.getInstance().setExtraPoints(player, this.categoryId, count);
    }

    @Override
    public void addExtraPoints(ServerPlayer player, int count) {
        SkillsMod.getInstance().addExtraPoints(player, this.categoryId, count);
    }

    @Override
    public int getPointsLeft(ServerPlayer player) {
        return SkillsMod.getInstance().getPointsLeft(player, this.categoryId).orElseThrow();
    }
}

