/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.experience;

import java.util.HashMap;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.ExperienceSourceWithDataFactory;
import net.puffish.skillsmod.api.experience.ExperienceSourceWithoutDataFactory;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.experience.ExperienceSourceFactory;

public class ExperienceSourceRegistry {
    private static final HashMap<ResourceLocation, ExperienceSourceFactory> factories = new HashMap();

    public static void register(ResourceLocation key, ExperienceSourceWithDataFactory factory) {
        ExperienceSourceRegistry.register(key, (Result<JsonElementWrapper, Failure> maybeData, ConfigContext context) -> maybeData.andThen(data -> factory.create((JsonElementWrapper)data, context)));
    }

    public static void register(ResourceLocation key, ExperienceSourceWithoutDataFactory factory) {
        ExperienceSourceRegistry.register(key, (Result<JsonElementWrapper, Failure> maybeData, ConfigContext context) -> factory.create(context));
    }

    private static void register(ResourceLocation key, ExperienceSourceFactory factory) {
        factories.compute(key, (key2, old) -> {
            if (old == null) {
                return factory;
            }
            throw new IllegalStateException("Trying to add duplicate key `" + key + "`'` to registry");
        });
    }

    public static Optional<ExperienceSourceFactory> getFactory(ResourceLocation key) {
        return Optional.ofNullable(factories.get(key));
    }
}

