/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.skill;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.rewards.Reward;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.rewards.RewardRegistry;
import net.puffish.skillsmod.rewards.builtin.DummyReward;

public class SkillRewardConfig {
    private final ResourceLocation type;
    private final Reward instance;

    private SkillRewardConfig(ResourceLocation type, Reward instance) {
        this.type = type;
        this.instance = instance;
    }

    public static Result<SkillRewardConfig, Failure> parse(JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(rootObject -> SkillRewardConfig.parse(rootObject, context));
    }

    public static Result<SkillRewardConfig, Failure> parse(JsonObjectWrapper rootObject, ConfigContext context) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional<JsonElementWrapper> optTypeElement = rootObject.get("type").ifFailure(failures::add).getSuccess();
        Optional optType = optTypeElement.flatMap(typeElement -> JsonParseUtils.parseIdentifier(typeElement).ifFailure(failures::add).getSuccess());
        Result<JsonElementWrapper, Failure> maybeDataElement = rootObject.get("data");
        Boolean required = rootObject.getBoolean("required").getSuccessOrElse(e -> true);
        if (failures.isEmpty()) {
            return SkillRewardConfig.build((ResourceLocation)optType.orElseThrow(), maybeDataElement, rootObject.getPath().thenObject("type"), context).orElse(failure -> {
                if (required.booleanValue()) {
                    return Result.failure(failure);
                }
                failure.getMessages().forEach(context::addWarning);
                return Result.success(new SkillRewardConfig(DummyReward.ID, new DummyReward()));
            });
        }
        return Result.failure(Failure.fromMany(failures));
    }

    private static Result<SkillRewardConfig, Failure> build(ResourceLocation type, Result<JsonElementWrapper, Failure> maybeDataElement, JsonPath typePath, ConfigContext context) {
        return RewardRegistry.getFactory(type).map(factory -> factory.create(maybeDataElement, context).mapSuccess(instance -> new SkillRewardConfig(type, (Reward)instance))).orElseGet(() -> Result.failure(typePath.createFailure("Expected a valid reward type")));
    }

    public void dispose(MinecraftServer server) {
        this.instance.dispose(server);
    }

    public ResourceLocation getType() {
        return this.type;
    }

    public Reward getInstance() {
        return this.instance;
    }
}

