/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.skill;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.FrameType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.config.FrameConfig;
import net.puffish.skillsmod.config.IconConfig;
import net.puffish.skillsmod.config.skill.SkillRewardConfig;

public class SkillDefinitionConfig {
    private final String id;
    private final Component title;
    private final Component description;
    private final Component extraDescription;
    private final IconConfig icon;
    private final FrameConfig frame;
    private final float size;
    private final List<SkillRewardConfig> rewards;
    private final int cost;
    private final int requiredPoints;
    private final int requiredSpentPoints;

    private SkillDefinitionConfig(String id, Component title, Component description, Component extraDescription, IconConfig icon, FrameConfig frame, float size, List<SkillRewardConfig> rewards, int cost, int requiredPoints, int requiredSpentPoints) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.extraDescription = extraDescription;
        this.icon = icon;
        this.frame = frame;
        this.size = size;
        this.rewards = rewards;
        this.cost = cost;
        this.requiredPoints = requiredPoints;
        this.requiredSpentPoints = requiredSpentPoints;
    }

    public static Result<SkillDefinitionConfig, Failure> parse(String id, JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(rootObject -> SkillDefinitionConfig.parse(id, rootObject, context));
    }

    public static Result<SkillDefinitionConfig, Failure> parse(String id, JsonObjectWrapper rootObject, ConfigContext context) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional optTitle = rootObject.get("title").andThen(JsonParseUtils::parseText).ifFailure(failures::add).getSuccess();
        Component description = rootObject.get("description").getSuccess().flatMap(descriptionElement -> JsonParseUtils.parseText(descriptionElement).ifFailure(failures::add).getSuccess()).orElseGet(Component::m_237119_);
        Component extraDescription = rootObject.get("extra_description").getSuccess().flatMap(descriptionElement -> JsonParseUtils.parseText(descriptionElement).ifFailure(failures::add).getSuccess()).orElseGet(Component::m_237119_);
        Optional optIcon = rootObject.get("icon").andThen(IconConfig::parse).ifFailure(failures::add).getSuccess();
        FrameConfig frame = rootObject.get("frame").getSuccess().flatMap(frameElement -> JsonParseUtils.parseFrame(frameElement).mapSuccess(FrameConfig::fromAdvancementFrame).orElse(failure -> FrameConfig.parse(frameElement)).ifFailure(failures::add).getSuccess()).orElseGet(() -> FrameConfig.fromAdvancementFrame(FrameType.TASK));
        Float size = rootObject.getFloat("size").getSuccess().orElse(Float.valueOf(1.0f));
        List rewards = rootObject.getArray("rewards").andThen(array -> array.getAsList((i, element) -> SkillRewardConfig.parse(element, context)).mapFailure(Failure::fromMany)).ifFailure(failures::add).getSuccess().orElseGet(List::of);
        Integer cost = rootObject.getInt("cost").getSuccess().orElse(1);
        Integer requiredPoints = rootObject.getInt("required_points").getSuccess().orElse(0);
        Integer requiredSpentPoints = rootObject.getInt("required_spent_points").getSuccess().orElse(0);
        if (failures.isEmpty()) {
            return Result.success(new SkillDefinitionConfig(id, (Component)optTitle.orElseThrow(), description, extraDescription, (IconConfig)optIcon.orElseThrow(), frame, size.floatValue(), rewards, cost, requiredPoints, requiredSpentPoints));
        }
        return Result.failure(Failure.fromMany(failures));
    }

    public void dispose(MinecraftServer server) {
        for (SkillRewardConfig reward : this.rewards) {
            reward.dispose(server);
        }
    }

    public String getId() {
        return this.id;
    }

    public Component getTitle() {
        return this.title;
    }

    public Component getDescription() {
        return this.description;
    }

    public Component getExtraDescription() {
        return this.extraDescription;
    }

    public FrameConfig getFrame() {
        return this.frame;
    }

    public float getSize() {
        return this.size;
    }

    public IconConfig getIcon() {
        return this.icon;
    }

    public List<SkillRewardConfig> getRewards() {
        return this.rewards;
    }

    public int getCost() {
        return this.cost;
    }

    public int getRequiredPoints() {
        return this.requiredPoints;
    }

    public int getRequiredSpentPoints() {
        return this.requiredSpentPoints;
    }
}

