/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.reader;

import java.io.BufferedReader;
import java.nio.file.Path;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.config.reader.ConfigReader;
import net.puffish.skillsmod.utils.PathUtils;

public class PackConfigReader
extends ConfigReader {
    private final ResourceManager resourceManager;
    private final String namespace;

    public PackConfigReader(ResourceManager resourceManager, String namespace) {
        this.resourceManager = resourceManager;
        this.namespace = namespace;
    }

    public Result<JsonElementWrapper, Failure> readResource(ResourceLocation id, Resource resource) {
        Result<JsonElementWrapper, Failure> result;
        block8: {
            BufferedReader reader = resource.m_215508_();
            try {
                result = JsonElementWrapper.parseReader(reader, JsonPath.named(id.toString()));
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return Result.failure(Failure.message("Failed to read resource `" + id + "`"));
                }
            }
            reader.close();
        }
        return result;
    }

    @Override
    public Result<JsonElementWrapper, Failure> read(Path path) {
        ResourceLocation id = ResourceLocation.m_214293_((String)this.namespace, (String)PathUtils.pathToString(Path.of("puffish_skills", new String[0]).resolve(path)));
        return this.resourceManager.m_213713_(id).map(resource -> this.readResource(id, (Resource)resource)).orElseGet(() -> Result.failure(Failure.message("Resource `" + id + "` does not exist")));
    }

    @Override
    public boolean exists(Path path) {
        ResourceLocation id = ResourceLocation.m_214293_((String)this.namespace, (String)PathUtils.pathToString(Path.of("puffish_skills", new String[0]).resolve(path)));
        return this.resourceManager.m_213713_(id).isPresent();
    }
}

