/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.reader;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.config.CategoryConfig;

public abstract class ConfigReader {
    public abstract Result<JsonElementWrapper, Failure> read(Path var1);

    public abstract boolean exists(Path var1);

    public Result<Map<ResourceLocation, CategoryConfig>, Failure> readCategories(String namespace, List<String> ids, ConfigContext context) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        LinkedHashMap map = new LinkedHashMap();
        for (String id : ids) {
            this.readCategory(namespace, id, context).peek(category -> map.put(ResourceLocation.m_214293_((String)namespace, (String)id), category), failures::add);
        }
        if (failures.isEmpty()) {
            return Result.success(map);
        }
        return Result.failure(Failure.fromMany(failures));
    }

    public Result<CategoryConfig, Failure> readCategory(String namespace, String id, ConfigContext context) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional<JsonElementWrapper> optGeneralElement = this.read(Path.of("categories", id, "category.json")).ifFailure(failures::add).getSuccess();
        Optional<JsonElementWrapper> optDefinitionsElement = this.read(Path.of("categories", id, "definitions.json")).ifFailure(failures::add).getSuccess();
        Optional<JsonElementWrapper> optSkillsElement = this.read(Path.of("categories", id, "skills.json")).ifFailure(failures::add).getSuccess();
        Optional<JsonElementWrapper> optConnectionsElement = this.read(Path.of("categories", id, "connections.json")).ifFailure(failures::add).getSuccess();
        Optional<JsonElementWrapper> optExperienceElement = Optional.empty();
        Path experiencePath = Path.of("categories", id, "experience.json");
        if (this.exists(experiencePath)) {
            optExperienceElement = this.read(experiencePath).ifFailure(failures::add).getSuccess();
        }
        if (failures.isEmpty()) {
            return CategoryConfig.parse(ResourceLocation.m_214293_((String)namespace, (String)id), optGeneralElement.orElseThrow(), optDefinitionsElement.orElseThrow(), optSkillsElement.orElseThrow(), optConnectionsElement.orElseThrow(), optExperienceElement, context);
        }
        return Result.failure(Failure.fromMany(failures));
    }
}

