/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.experience;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.ExperienceSource;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.experience.ExperienceSourceRegistry;

public class ExperienceSourceConfig {
    private final ResourceLocation type;
    private final ExperienceSource instance;

    private ExperienceSourceConfig(ResourceLocation type, ExperienceSource instance) {
        this.type = type;
        this.instance = instance;
    }

    public static Result<ExperienceSourceConfig, Failure> parse(JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(rootObject -> ExperienceSourceConfig.parse(rootObject, context));
    }

    public static Result<ExperienceSourceConfig, Failure> parse(JsonObjectWrapper rootObject, ConfigContext context) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional<JsonElementWrapper> optTypeElement = rootObject.get("type").ifFailure(failures::add).getSuccess();
        Optional optType = optTypeElement.flatMap(typeElement -> JsonParseUtils.parseIdentifier(typeElement).ifFailure(failures::add).getSuccess());
        Result<JsonElementWrapper, Failure> maybeDataElement = rootObject.get("data");
        if (failures.isEmpty()) {
            return ExperienceSourceConfig.build((ResourceLocation)optType.orElseThrow(), maybeDataElement, optTypeElement.orElseThrow().getPath(), context);
        }
        return Result.failure(Failure.fromMany(failures));
    }

    private static Result<ExperienceSourceConfig, Failure> build(ResourceLocation type, Result<JsonElementWrapper, Failure> maybeDataElement, JsonPath typeElementPath, ConfigContext context) {
        return ExperienceSourceRegistry.getFactory(type).map(factory -> factory.create(maybeDataElement, context).mapSuccess(instance -> new ExperienceSourceConfig(type, (ExperienceSource)instance))).orElseGet(() -> Result.failure(typeElementPath.createFailure("Expected a valid source type")));
    }

    public void dispose(MinecraftServer server) {
        this.instance.dispose(server);
    }

    public ResourceLocation getType() {
        return this.type;
    }

    public ExperienceSource getInstance() {
        return this.instance;
    }
}

