/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.api.Skill;

public class SkillArgumentType
implements ArgumentType<String> {
    private static final DynamicCommandExceptionType NO_SUCH_SKILL = new DynamicCommandExceptionType(id -> SkillsMod.createTranslatable("command", "no_such_skill", id));
    private final String categoryArgumentName;

    private SkillArgumentType(String categoryArgumentName) {
        this.categoryArgumentName = categoryArgumentName;
    }

    public static SkillArgumentType skillFromCategory(String categoryArgumentName) {
        return new SkillArgumentType(categoryArgumentName);
    }

    public static Skill getSkillFromCategory(CommandContext<CommandSourceStack> context, String name, Category category) throws CommandSyntaxException {
        String skillId = (String)context.getArgument(name, String.class);
        return category.getSkill(skillId).orElseThrow(() -> NO_SUCH_SKILL.create((Object)skillId));
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        return reader.readString();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Object source = context.getSource();
        if (source instanceof CommandSourceStack) {
            ResourceLocation categoryId = SkillsMod.convertIdentifier((ResourceLocation)context.getArgument(this.categoryArgumentName, ResourceLocation.class));
            SkillsMod.getInstance().getSkills(categoryId).ifPresent(skills -> SharedSuggestionProvider.m_82970_((Iterable)skills, (SuggestionsBuilder)builder));
            return builder.buildFuture();
        }
        if (source instanceof SharedSuggestionProvider) {
            SharedSuggestionProvider commandSource = (SharedSuggestionProvider)source;
            return commandSource.m_212155_(context);
        }
        return Suggestions.empty();
    }

    public static class Serializer
    implements ArgumentTypeInfo<SkillArgumentType, Properties> {
        public void writePacket(Properties properties, FriendlyByteBuf buf) {
            buf.m_130070_(properties.categoryArgumentName);
        }

        public Properties fromPacket(FriendlyByteBuf buf) {
            return new Properties(buf.m_130277_());
        }

        public void writeJson(Properties properties, JsonObject jsonObject) {
            jsonObject.addProperty("category_argument_name", properties.categoryArgumentName);
        }

        public Properties getArgumentTypeProperties(SkillArgumentType skillArgumentType) {
            return new Properties(skillArgumentType.categoryArgumentName);
        }

        public final class Properties
        implements ArgumentTypeInfo.Template<SkillArgumentType> {
            private final String categoryArgumentName;

            public Properties(String categoryArgumentName) {
                this.categoryArgumentName = categoryArgumentName;
            }

            public SkillArgumentType createType(CommandBuildContext commandRegistryAccess) {
                return new SkillArgumentType(this.categoryArgumentName);
            }

            public ArgumentTypeInfo<SkillArgumentType, ?> m_213709_() {
                return Serializer.this;
            }
        }
    }
}

