/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;

public class ConnectionBatchedRenderer {
    private final List<TriangleEmit> normalEmits = new ArrayList<TriangleEmit>();
    private final List<TriangleEmit> exclusiveEmits = new ArrayList<TriangleEmit>();
    private final List<TriangleEmit> outlineEmits = new ArrayList<TriangleEmit>();

    public void emitNormalConnection(GuiGraphics context, float startX, float startY, float endX, float endY, boolean bidirectional) {
        this.emitConnection(context, startX, startY, endX, endY, bidirectional, this.normalEmits);
    }

    public void emitExclusiveConnection(GuiGraphics context, float startX, float startY, float endX, float endY, boolean bidirectional) {
        this.emitConnection(context, startX, startY, endX, endY, bidirectional, this.exclusiveEmits);
    }

    private void emitConnection(GuiGraphics context, float startX, float startY, float endX, float endY, boolean bidirectional, List<TriangleEmit> emits) {
        Matrix4f matrix = context.m_280168_().m_85850_().m_252922_();
        this.emitLine(matrix, this.outlineEmits, startX, startY, endX, endY, 3.0f);
        if (!bidirectional) {
            this.emitArrow(matrix, this.outlineEmits, startX, startY, endX, endY, 8.0f);
        }
        this.emitLine(matrix, emits, startX, startY, endX, endY, 1.0f);
        if (!bidirectional) {
            this.emitArrow(matrix, emits, startX, startY, endX, endY, 6.0f);
        }
    }

    private void emitLine(Matrix4f matrix, List<TriangleEmit> emits, float startX, float startY, float endX, float endY, float thickness) {
        Vector2f side = new Vector2f(endX, endY).sub(startX, startY).normalize().perpendicular().mul(thickness / 2.0f);
        this.emitTriangle(matrix, emits, startX + side.x, startY + side.y, startX - side.x, startY - side.y, endX + side.x, endY + side.y);
        this.emitTriangle(matrix, emits, endX - side.x, endY - side.y, endX + side.x, endY + side.y, startX - side.x, startY - side.y);
    }

    private void emitArrow(Matrix4f matrix, List<TriangleEmit> emits, float startX, float startY, float endX, float endY, float thickness) {
        Vector2f center = new Vector2f(endX, endY).add(startX, startY).div(2.0f);
        Vector2f normal = new Vector2f(endX, endY).sub(startX, startY).normalize();
        Vector2f forward = new Vector2f((Vector2fc)normal).mul(thickness);
        Vector2f backward = new Vector2f((Vector2fc)forward).div(-2.0f);
        Vector2f back = new Vector2f((Vector2fc)center).add((Vector2fc)backward);
        Vector2f side = new Vector2f((Vector2fc)backward).perpendicular().mul(Mth.m_14116_((float)3.0f));
        this.emitTriangle(matrix, emits, center.x + forward.x, center.y + forward.y, back.x - side.x, back.y - side.y, back.x + side.x, back.y + side.y);
    }

    private void emitTriangle(Matrix4f matrix, List<TriangleEmit> emits, float x1, float y1, float x2, float y2, float x3, float y3) {
        Vector3f v1 = matrix.transformPosition(new Vector3f(x1, y1, 0.0f));
        Vector3f v2 = matrix.transformPosition(new Vector3f(x2, y2, 0.0f));
        Vector3f v3 = matrix.transformPosition(new Vector3f(x3, y3, 0.0f));
        emits.add(new TriangleEmit(v1.x, v1.y, v1.z, v2.x, v2.y, v2.z, v3.x, v3.y, v3.z));
    }

    public void draw() {
        RenderSystem.setShader(GameRenderer::m_172808_);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.drawBatch(this.outlineEmits);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBatch(this.normalEmits);
        RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.drawBatch(this.exclusiveEmits);
    }

    private void drawBatch(List<TriangleEmit> emits) {
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85814_);
        for (TriangleEmit emit : emits) {
            bufferBuilder.m_5483_((double)emit.x1, (double)emit.y1, (double)emit.z1).m_5752_();
            bufferBuilder.m_5483_((double)emit.x2, (double)emit.y2, (double)emit.z2).m_5752_();
            bufferBuilder.m_5483_((double)emit.x3, (double)emit.y3, (double)emit.z3).m_5752_();
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    private record TriangleEmit(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3) {
    }
}

