/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.network.packets.in;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.client.data.ClientFrameData;
import net.puffish.skillsmod.client.data.ClientIconData;
import net.puffish.skillsmod.client.data.ClientSkillCategoryData;
import net.puffish.skillsmod.client.data.ClientSkillConnectionData;
import net.puffish.skillsmod.client.data.ClientSkillData;
import net.puffish.skillsmod.client.data.ClientSkillDefinitionData;
import net.puffish.skillsmod.network.InPacket;
import net.puffish.skillsmod.skill.SkillState;

public class ShowCategoryInPacket
implements InPacket {
    private final ClientSkillCategoryData category;

    private ShowCategoryInPacket(ClientSkillCategoryData category) {
        this.category = category;
    }

    public static ShowCategoryInPacket read(FriendlyByteBuf buf) {
        ClientSkillCategoryData category = ShowCategoryInPacket.readCategory(buf);
        return new ShowCategoryInPacket(category);
    }

    public static ClientSkillCategoryData readCategory(FriendlyByteBuf buf) {
        ResourceLocation id = buf.m_130281_();
        Component title = buf.m_130238_();
        ClientIconData icon = ShowCategoryInPacket.readSkillIcon(buf);
        ResourceLocation background = buf.m_130281_();
        boolean exclusiveRoot = buf.readBoolean();
        int spentPointsLimit = buf.readInt();
        Map<String, ClientSkillDefinitionData> definitions = buf.m_236845_(ShowCategoryInPacket::readDefinition).stream().collect(Collectors.toMap(ClientSkillDefinitionData::getId, definition -> definition));
        Map<String, ClientSkillData> skills = buf.m_236845_(ShowCategoryInPacket::readSkill).stream().collect(Collectors.toMap(ClientSkillData::getId, skill -> skill));
        List normalConnections = buf.m_236845_(ShowCategoryInPacket::readSkillConnection);
        List exclusiveConnections = buf.m_236845_(ShowCategoryInPacket::readSkillConnection);
        int spentPoints = buf.readInt();
        int earnedPoints = buf.readInt();
        int currentLevel = Integer.MIN_VALUE;
        int currentExperience = Integer.MIN_VALUE;
        int requiredExperience = Integer.MIN_VALUE;
        if (buf.readBoolean()) {
            currentLevel = buf.readInt();
            currentExperience = buf.readInt();
            requiredExperience = buf.readInt();
        }
        return new ClientSkillCategoryData(id, title, icon, background, exclusiveRoot, spentPointsLimit, definitions, skills, normalConnections, exclusiveConnections, spentPoints, earnedPoints, currentLevel, currentExperience, requiredExperience);
    }

    public static ClientSkillDefinitionData readDefinition(FriendlyByteBuf buf) {
        String id = buf.m_130277_();
        Component title = buf.m_130238_();
        Component description = buf.m_130238_();
        Component extraDescription = buf.m_130238_();
        ClientFrameData frame = ShowCategoryInPacket.readFrameIcon(buf);
        ClientIconData icon = ShowCategoryInPacket.readSkillIcon(buf);
        float size = buf.readFloat();
        return new ClientSkillDefinitionData(id, title, description, extraDescription, frame, icon, size);
    }

    public static ClientIconData readSkillIcon(FriendlyByteBuf buf) {
        String type = buf.m_130277_();
        return buf.m_236860_(FriendlyByteBuf::m_130277_).flatMap(data -> JsonElementWrapper.parseString(data, JsonPath.named("Client Skill Icon")).getSuccess()).flatMap(rootElement -> switch (type) {
            case "item" -> ClientIconData.ItemIconData.parse(rootElement).getSuccess();
            case "effect" -> ClientIconData.EffectIconData.parse(rootElement).getSuccess();
            case "texture" -> ClientIconData.TextureIconData.parse(rootElement).getSuccess();
            default -> Optional.empty();
        }).orElseGet(ClientIconData.TextureIconData::createMissing);
    }

    public static ClientFrameData readFrameIcon(FriendlyByteBuf buf) {
        String type = buf.m_130277_();
        return buf.m_236860_(FriendlyByteBuf::m_130277_).flatMap(data -> JsonElementWrapper.parseString(data, JsonPath.named("Client Frame Icon")).getSuccess()).flatMap(rootElement -> switch (type) {
            case "advancement" -> ClientFrameData.AdvancementFrameData.parse(rootElement).getSuccess();
            case "texture" -> ClientFrameData.TextureFrameData.parse(rootElement).getSuccess();
            default -> Optional.empty();
        }).orElseGet(ClientFrameData.TextureFrameData::createMissing);
    }

    public static ClientSkillData readSkill(FriendlyByteBuf buf) {
        String id = buf.m_130277_();
        int x = buf.readInt();
        int y = buf.readInt();
        String definition = buf.m_130277_();
        boolean isRoot = buf.readBoolean();
        SkillState state = (SkillState)buf.m_130066_(SkillState.class);
        return new ClientSkillData(id, x, y, definition, isRoot, state);
    }

    public static ClientSkillConnectionData readSkillConnection(FriendlyByteBuf buf) {
        String skillAId = buf.m_130277_();
        String skillBId = buf.m_130277_();
        boolean bidirectional = buf.readBoolean();
        return new ClientSkillConnectionData(skillAId, skillBId, bidirectional);
    }

    public ClientSkillCategoryData getCategory() {
        return this.category;
    }
}

