/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.advancements.AdvancementWidgetType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.client.SkillsClientMod;
import net.puffish.skillsmod.client.data.ClientFrameData;
import net.puffish.skillsmod.client.data.ClientIconData;
import net.puffish.skillsmod.client.data.ClientSkillCategoryData;
import net.puffish.skillsmod.client.data.ClientSkillConnectionData;
import net.puffish.skillsmod.client.data.ClientSkillData;
import net.puffish.skillsmod.client.data.ClientSkillDefinitionData;
import net.puffish.skillsmod.client.network.packets.out.SkillClickOutPacket;
import net.puffish.skillsmod.client.rendering.ConnectionBatchedRenderer;
import net.puffish.skillsmod.client.rendering.ItemBatchedRenderer;
import net.puffish.skillsmod.client.rendering.TextureBatchedRenderer;
import net.puffish.skillsmod.skill.SkillState;
import net.puffish.skillsmod.utils.Bounds2i;
import org.joml.Vector2i;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class SkillsScreen
extends Screen {
    private static final ResourceLocation TABS_TEXTURE = new ResourceLocation("textures/gui/advancements/tabs.png");
    private static final ResourceLocation WINDOW_TEXTURE = new ResourceLocation("textures/gui/advancements/window.png");
    private static final ResourceLocation WIDGETS_TEXTURE = new ResourceLocation("textures/gui/advancements/widgets.png");
    private static final ResourceLocation ICONS_TEXTURE = new ResourceLocation("textures/gui/icons.png");
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int FRAME_WIDTH = 252;
    private static final int FRAME_HEIGHT = 140;
    private static final int FRAME_PADDING = 8;
    private static final int FRAME_CUT = 16;
    private static final int FRAME_EXPAND = 24;
    private static final int CONTENT_GROW = 32;
    private static final int TABS_HEIGHT = 28;
    private static final int HALF_FRAME_WIDTH = 126;
    private static final int HALF_FRAME_HEIGHT = 70;
    private static final Vector4fc COLOR_WHITE = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    private static final Vector4fc COLOR_GRAY = new Vector4f(0.25f, 0.25f, 0.25f, 1.0f);
    private final Map<ResourceLocation, ClientSkillCategoryData> categories;
    private Optional<ClientSkillCategoryData> optActiveCategory = Optional.empty();
    private int activeCategoryIndex = 0;
    private float minScale = 1.0f;
    private float maxScale = 1.0f;
    private float scale = 1.0f;
    private int x = 0;
    private int y = 0;
    private double dragStartX = 0.0;
    private double dragStartY = 0.0;
    private boolean dragging = false;
    private Bounds2i bounds = Bounds2i.zero();
    private boolean small = false;
    private int contentPaddingTop = 0;
    private int contentPaddingLeft = 0;
    private int contentPaddingRight = 0;
    private int contentPaddingBottom = 0;

    public SkillsScreen(Map<ResourceLocation, ClientSkillCategoryData> categories, Optional<ResourceLocation> optCategoryId) {
        super(CommonComponents.f_237098_);
        this.categories = categories;
        optCategoryId.ifPresent(categoryId -> {
            ResourceLocation id;
            Iterator iterator = categories.keySet().iterator();
            while (iterator.hasNext() && !(id = (ResourceLocation)iterator.next()).equals(categoryId)) {
                ++this.activeCategoryIndex;
            }
        });
    }

    protected void m_7856_() {
        super.m_7856_();
    }

    private void resize() {
        this.small = this.optActiveCategory.map(activeCategory -> activeCategory.hasExperience() && this.f_96543_ < 450).orElse(false);
        if (this.small) {
            this.contentPaddingTop = 62;
            this.contentPaddingLeft = 17;
            this.contentPaddingRight = 17;
            this.contentPaddingBottom = 17;
        } else {
            this.contentPaddingTop = 54;
            this.contentPaddingLeft = 17;
            this.contentPaddingRight = 17;
            this.contentPaddingBottom = 17;
        }
        this.x = this.f_96543_ / 2;
        this.y = this.f_96544_ / 2;
        this.bounds = this.optActiveCategory.map(ClientSkillCategoryData::getBounds).orElseGet(Bounds2i::zero);
        this.bounds.grow(32);
        this.bounds.extend(new Vector2i(this.contentPaddingLeft - this.x, this.contentPaddingTop - this.y));
        this.bounds.extend(new Vector2i(this.f_96543_ - this.x - this.contentPaddingRight, this.f_96544_ - this.y - this.contentPaddingBottom));
        int contentWidth = this.f_96543_ - this.contentPaddingLeft - this.contentPaddingRight;
        int contentHeight = this.f_96544_ - this.contentPaddingTop - this.contentPaddingBottom;
        int halfWidth = Mth.m_184652_((int)(this.bounds.height() * contentWidth), (int)(contentHeight * 2));
        int halfHeight = Mth.m_184652_((int)(this.bounds.width() * contentHeight), (int)(contentWidth * 2));
        this.bounds.extend(new Vector2i(-halfWidth, -halfHeight));
        this.bounds.extend(new Vector2i(halfWidth, halfHeight));
        this.minScale = Math.max((float)contentWidth / (float)this.bounds.width(), (float)contentHeight / (float)this.bounds.height());
        this.maxScale = 1.0f;
        this.scale = 1.0f;
    }

    private Vector2i getMousePos(double mouseX, double mouseY) {
        return new Vector2i((int)mouseX, (int)mouseY);
    }

    private Vector2i getTransformedMousePos(double mouseX, double mouseY) {
        return new Vector2i((int)Math.round((mouseX - (double)this.x) / (double)this.scale), (int)Math.round((mouseY - (double)this.y) / (double)this.scale));
    }

    private boolean isInsideTab(Vector2i mouse, int i) {
        return mouse.x >= 8 + i * 32 && mouse.y >= 8 && mouse.x < 8 + i * 32 + 28 && mouse.y < 40;
    }

    private boolean isInsideSkill(Vector2i transformedMouse, ClientSkillData skill, ClientSkillDefinitionData definition) {
        int halfSize = Math.round(13.0f * definition.getSize());
        return transformedMouse.x >= skill.getX() - halfSize && transformedMouse.y >= skill.getY() - halfSize && transformedMouse.x < skill.getX() + halfSize && transformedMouse.y < skill.getY() + halfSize;
    }

    private boolean isInsideContent(Vector2i mouse) {
        return mouse.x >= this.contentPaddingLeft && mouse.y >= this.contentPaddingTop && mouse.x < this.f_96543_ - this.contentPaddingRight && mouse.y < this.f_96544_ - this.contentPaddingBottom;
    }

    private boolean isInsideExperience(Vector2i mouse, int x, int y) {
        return mouse.x >= x && mouse.y >= y && mouse.x < x + 182 && mouse.y < y + 5;
    }

    private boolean isInsideArea(Vector2i mouse, int x1, int y1, int x2, int y2) {
        return mouse.x >= x1 && mouse.y >= y1 && mouse.x < x2 && mouse.y < y2;
    }

    private void syncCategory() {
        Optional<ClientSkillCategoryData> opt = this.categories.values().stream().skip(Math.max(0, Math.min(this.activeCategoryIndex, this.categories.size() - 1))).findFirst();
        if (!Objects.equals(opt, this.optActiveCategory)) {
            this.optActiveCategory = opt;
            this.resize();
        }
    }

    private void forEachCategory(BiConsumer<Integer, ClientSkillCategoryData> consumer) {
        Iterator<ClientSkillCategoryData> it = this.categories.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            consumer.accept(i, it.next());
            ++i;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.optActiveCategory.ifPresent(activeCategory -> this.mouseClickedWithCategory(mouseX, mouseY, button, (ClientSkillCategoryData)activeCategory));
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void mouseClickedWithCategory(double mouseX, double mouseY, int button, ClientSkillCategoryData activeCategory) {
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        Vector2i transformedMouse = this.getTransformedMousePos(mouseX, mouseY);
        if (this.isInsideContent(mouse)) {
            for (ClientSkillData skill : activeCategory.getSkills().values()) {
                ClientSkillDefinitionData definition = activeCategory.getDefinitions().get(skill.getDefinitionId());
                if (definition == null || !this.isInsideSkill(transformedMouse, skill, definition)) continue;
                SkillsClientMod.getInstance().getPacketSender().send(SkillClickOutPacket.write(activeCategory.getId(), skill.getId()));
            }
            if (button == 0) {
                this.dragStartX = mouseX - (double)this.x;
                this.dragStartY = mouseY - (double)this.y;
                this.dragging = true;
            }
        } else {
            this.dragging = false;
        }
        this.forEachCategory((i, category) -> {
            if (this.isInsideTab(mouse, (int)i)) {
                this.activeCategoryIndex = i;
                this.syncCategory();
            }
        });
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (SkillsClientMod.OPEN_KEY_BINDING.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.syncCategory();
        this.m_280273_(context);
        this.drawContent(context, mouseX, mouseY);
        this.drawWindow(context, mouseX, mouseY);
        this.drawTabs(context, mouseX, mouseY);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging && button == 0) {
            this.x = (int)Math.round(mouseX - this.dragStartX);
            this.y = (int)Math.round(mouseY - this.dragStartY);
            this.limitPosition();
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        float factor = (float)Math.pow(2.0, amount * 0.25);
        this.scale *= factor;
        if (this.scale < this.minScale) {
            this.scale = this.minScale;
            factor = this.minScale / this.scale;
        }
        if (this.scale > this.maxScale) {
            this.scale = this.maxScale;
            factor = this.maxScale / this.scale;
        }
        this.x -= (int)Math.round((double)(factor - 1.0f) * (mouseX - (double)this.x));
        this.y -= (int)Math.round((double)(factor - 1.0f) * (mouseY - (double)this.y));
        this.limitPosition();
        return super.m_6050_(mouseX, mouseY, amount);
    }

    private void limitPosition() {
        this.y = Math.min(this.y, (int)Math.floor((float)this.contentPaddingTop - (float)this.bounds.min().y() * this.scale));
        this.x = Math.min(this.x, (int)Math.floor((float)this.contentPaddingLeft - (float)this.bounds.min().x() * this.scale));
        this.x = Math.max(this.x, (int)Math.ceil((float)(this.f_96543_ - this.contentPaddingRight) - (float)this.bounds.max().x() * this.scale));
        this.y = Math.max(this.y, (int)Math.ceil((float)(this.f_96544_ - this.contentPaddingBottom) - (float)this.bounds.max().y() * this.scale));
    }

    private void drawIcon(GuiGraphics context, TextureBatchedRenderer textureRenderer, ItemBatchedRenderer itemRenderer, ClientIconData icon, float sizeScale, int x, int y) {
        if (this.f_96541_ == null) {
            return;
        }
        PoseStack matrices = context.m_280168_();
        matrices.m_85836_();
        if (icon instanceof ClientIconData.ItemIconData) {
            ClientIconData.ItemIconData itemIcon = (ClientIconData.ItemIconData)icon;
            matrices.m_252880_((float)x * (1.0f - sizeScale), (float)y * (1.0f - sizeScale), 1.0f);
            matrices.m_85841_(sizeScale, sizeScale, 1.0f);
            itemRenderer.emitItem(context, itemIcon.getItem(), x, y);
        } else if (icon instanceof ClientIconData.EffectIconData) {
            ClientIconData.EffectIconData effectIcon = (ClientIconData.EffectIconData)icon;
            matrices.m_252880_(0.0f, 0.0f, 1.0f);
            TextureAtlasSprite sprite = this.f_96541_.m_91306_().m_118732_(effectIcon.getEffect());
            int halfSize = Math.round(9.0f * sizeScale);
            int size = halfSize * 2;
            textureRenderer.emitSpriteStretch(context, sprite, x - halfSize, y - halfSize, size, size, COLOR_WHITE);
        } else if (icon instanceof ClientIconData.TextureIconData) {
            ClientIconData.TextureIconData textureIcon = (ClientIconData.TextureIconData)icon;
            matrices.m_252880_(0.0f, 0.0f, 1.0f);
            int halfSize = Math.round(8.0f * sizeScale);
            int size = halfSize * 2;
            textureRenderer.emitTexture(context, textureIcon.getTexture(), x - halfSize, y - halfSize, size, size, COLOR_WHITE);
        }
        matrices.m_85849_();
    }

    private void drawFrame(GuiGraphics context, TextureBatchedRenderer textureRenderer, ClientFrameData frame, float sizeScale, int x, int y, SkillState state) {
        if (this.f_96541_ == null) {
            return;
        }
        int halfSize = Math.round(13.0f * sizeScale);
        int size = halfSize * 2;
        if (frame instanceof ClientFrameData.AdvancementFrameData) {
            ClientFrameData.AdvancementFrameData advancementFrame = (ClientFrameData.AdvancementFrameData)frame;
            AdvancementWidgetType status = state == SkillState.UNLOCKED ? AdvancementWidgetType.OBTAINED : AdvancementWidgetType.UNOBTAINED;
            Vector4fc color = switch (state) {
                default -> throw new IncompatibleClassChangeError();
                case SkillState.LOCKED, SkillState.EXCLUDED -> COLOR_GRAY;
                case SkillState.AVAILABLE, SkillState.UNLOCKED -> COLOR_WHITE;
            };
            textureRenderer.emitTexture(context, WIDGETS_TEXTURE, x - halfSize, y - halfSize, size, size, (float)advancementFrame.getFrame().m_15551_() / 256.0f, (float)(128 + status.m_97325_() * 26) / 256.0f, (float)(advancementFrame.getFrame().m_15551_() + 26) / 256.0f, (float)(128 + status.m_97325_() * 26 + 26) / 256.0f, color);
        } else if (frame instanceof ClientFrameData.TextureFrameData) {
            ClientFrameData.TextureFrameData textureFrame = (ClientFrameData.TextureFrameData)frame;
            switch (state) {
                case AVAILABLE: {
                    textureRenderer.emitTexture(context, textureFrame.getAvailableTexture(), x - halfSize, y - halfSize, size, size, COLOR_WHITE);
                    break;
                }
                case UNLOCKED: {
                    textureRenderer.emitTexture(context, textureFrame.getUnlockedTexture(), x - halfSize, y - halfSize, size, size, COLOR_WHITE);
                    break;
                }
                case LOCKED: {
                    if (textureFrame.getLockedTexture() != null) {
                        textureRenderer.emitTexture(context, textureFrame.getLockedTexture(), x - halfSize, y - halfSize, size, size, COLOR_WHITE);
                        break;
                    }
                    textureRenderer.emitTexture(context, textureFrame.getAvailableTexture(), x - halfSize, y - halfSize, size, size, COLOR_GRAY);
                    break;
                }
                case EXCLUDED: {
                    if (textureFrame.getExcludedTexture() != null) {
                        textureRenderer.emitTexture(context, textureFrame.getExcludedTexture(), x - halfSize, y - halfSize, size, size, COLOR_WHITE);
                        break;
                    }
                    textureRenderer.emitTexture(context, textureFrame.getAvailableTexture(), x - halfSize, y - halfSize, size, size, COLOR_GRAY);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    private void drawContent(GuiGraphics context, double mouseX, double mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        context.m_280588_(this.contentPaddingLeft - 4, this.contentPaddingTop - 4, this.f_96543_ - this.contentPaddingRight + 4, this.f_96544_ - this.contentPaddingBottom + 4);
        this.optActiveCategory.ifPresentOrElse(activeCategory -> this.drawContentWithCategory(context, mouseX, mouseY, (ClientSkillCategoryData)activeCategory), () -> this.drawContentWithoutCategory(context));
        context.m_280618_();
    }

    private void drawContentWithCategory(GuiGraphics context, double mouseX, double mouseY, ClientSkillCategoryData activeCategory) {
        if (this.f_96541_ == null) {
            return;
        }
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        Vector2i transformedMouse = this.getTransformedMousePos(mouseX, mouseY);
        PoseStack matrices = context.m_280168_();
        matrices.m_85836_();
        matrices.m_252880_((float)this.x, (float)this.y, 0.0f);
        matrices.m_85841_(this.scale, this.scale, 1.0f);
        context.m_280163_(activeCategory.getBackground(), this.bounds.min().x(), this.bounds.min().y(), 0.0f, 0.0f, this.bounds.width(), this.bounds.height(), 16, 16);
        ConnectionBatchedRenderer connectionRenderer = new ConnectionBatchedRenderer();
        for (ClientSkillConnectionData connection : activeCategory.getNormalConnections()) {
            ClientSkillData skillA = activeCategory.getSkills().get(connection.getSkillAId());
            ClientSkillData skillB = activeCategory.getSkills().get(connection.getSkillBId());
            if (skillA == null || skillB == null) continue;
            connectionRenderer.emitNormalConnection(context, skillA.getX(), skillA.getY(), skillB.getX(), skillB.getY(), connection.isBidirectional());
        }
        if (this.isInsideContent(mouse)) {
            Optional<ClientSkillData> optHoveredSkill = activeCategory.getSkills().values().stream().filter(skill -> {
                ClientSkillDefinitionData definition = activeCategory.getDefinitions().get(skill.getDefinitionId());
                if (definition == null) {
                    return false;
                }
                return this.isInsideSkill(transformedMouse, (ClientSkillData)skill, definition);
            }).findFirst();
            optHoveredSkill.ifPresent(hoveredSkill -> {
                ClientSkillDefinitionData definition = activeCategory.getDefinitions().get(hoveredSkill.getDefinitionId());
                if (definition == null) {
                    return;
                }
                ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
                lines.add(definition.getTitle().m_7532_());
                lines.addAll(Tooltip.m_257868_((Minecraft)this.f_96541_, (Component)ComponentUtils.m_130750_((MutableComponent)definition.getDescription().m_6881_(), (Style)Style.f_131099_.m_131157_(ChatFormatting.GRAY))));
                if (Screen.m_96638_()) {
                    lines.addAll(Tooltip.m_257868_((Minecraft)this.f_96541_, (Component)ComponentUtils.m_130750_((MutableComponent)definition.getExtraDescription().m_6881_(), (Style)Style.f_131099_.m_131157_(ChatFormatting.GRAY))));
                }
                if (this.f_96541_.f_91066_.f_92125_) {
                    lines.add(Component.m_237113_((String)hoveredSkill.getId()).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
                }
                this.m_257959_(lines);
                Collection<ClientSkillConnectionData> connections = activeCategory.getExclusiveConnections().get(hoveredSkill.getId());
                if (connections != null) {
                    for (ClientSkillConnectionData connection : connections) {
                        ClientSkillData skillA = activeCategory.getSkills().get(connection.getSkillAId());
                        ClientSkillData skillB = activeCategory.getSkills().get(connection.getSkillBId());
                        if (skillA == null || skillB == null) continue;
                        connectionRenderer.emitExclusiveConnection(context, skillA.getX(), skillA.getY(), skillB.getX(), skillB.getY(), connection.isBidirectional());
                    }
                }
            });
        }
        connectionRenderer.draw();
        TextureBatchedRenderer textureRenderer = new TextureBatchedRenderer();
        ItemBatchedRenderer itemRenderer = new ItemBatchedRenderer();
        for (ClientSkillData skill2 : activeCategory.getSkills().values()) {
            ClientSkillDefinitionData definition = activeCategory.getDefinitions().get(skill2.getDefinitionId());
            if (definition == null) continue;
            this.drawFrame(context, textureRenderer, definition.getFrame(), definition.getSize(), skill2.getX(), skill2.getY(), skill2.getState());
            this.drawIcon(context, textureRenderer, itemRenderer, definition.getIcon(), definition.getSize(), skill2.getX(), skill2.getY());
        }
        textureRenderer.draw();
        itemRenderer.draw();
        matrices.m_85849_();
    }

    private void drawContentWithoutCategory(GuiGraphics context) {
        context.m_280509_(0, 0, this.f_96543_, this.f_96544_, -16777216);
        int tmpX = this.contentPaddingLeft + (this.f_96543_ - this.contentPaddingLeft - this.contentPaddingRight) / 2;
        MutableComponent mutableComponent = Component.m_237115_((String)"advancements.sad_label");
        Objects.requireNonNull(this.f_96547_);
        context.m_280653_(this.f_96547_, (Component)mutableComponent, tmpX, this.f_96544_ - this.contentPaddingBottom - 9, -1);
        MutableComponent mutableComponent2 = Component.m_237115_((String)"advancements.empty");
        Objects.requireNonNull(this.f_96547_);
        context.m_280653_(this.f_96547_, (Component)mutableComponent2, tmpX, this.contentPaddingTop + (this.f_96544_ - this.contentPaddingTop - this.contentPaddingBottom - 9) / 2, -1);
    }

    private void drawTabs(GuiGraphics context, double mouseX, double mouseY) {
        if (this.f_96541_ == null) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableDepthTest();
        this.forEachCategory((i, category) -> context.m_280218_(TABS_TEXTURE, 8 + 32 * i, 8, i > 0 ? 28 : 0, this.optActiveCategory.orElse(null) == category ? 32 : 0, 28, 32));
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        TextureBatchedRenderer textureRenderer = new TextureBatchedRenderer();
        ItemBatchedRenderer itemBatch = new ItemBatchedRenderer();
        this.forEachCategory((i, category) -> {
            this.drawIcon(context, textureRenderer, itemBatch, category.getIcon(), 1.0f, 8 + 32 * i + 6 + 8, 25);
            if (this.isInsideTab(mouse, (int)i)) {
                ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
                lines.add(category.getTitle().m_7532_());
                if (this.f_96541_.f_91066_.f_92125_) {
                    lines.add(Component.m_237113_((String)category.getId().toString()).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
                }
                this.m_257959_(lines);
            }
        });
        textureRenderer.draw();
        itemBatch.draw();
    }

    private void drawWindow(GuiGraphics context, double mouseX, double mouseY) {
        if (this.f_96541_ == null) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableDepthTest();
        context.m_280163_(WINDOW_TEXTURE, 8, this.f_96544_ - 8 - 70 + 1, 0.0f, 70.0f, 126, 70, 256, 256);
        context.m_280163_(WINDOW_TEXTURE, this.f_96543_ - 8 - 126 + 1, this.f_96544_ - 8 - 70 + 1, 126.0f, 70.0f, 126, 70, 256, 256);
        context.m_280411_(WINDOW_TEXTURE, 8, 78, 126, this.f_96544_ - 16 - 140 + 1, 0.0f, 69.0f, 126, 2, 256, 256);
        context.m_280411_(WINDOW_TEXTURE, 134, this.f_96544_ - 8 - 70 + 1, this.f_96543_ - 16 - 252 + 1, 70, 125.0f, 70.0f, 2, 70, 256, 256);
        context.m_280411_(WINDOW_TEXTURE, this.f_96543_ - 8 - 126 + 1, 78, 126, this.f_96544_ - 16 - 140 + 1, 126.0f, 69.0f, 126, 2, 256, 256);
        if (this.small) {
            context.m_280163_(WINDOW_TEXTURE, 8, 36, 0.0f, 0.0f, 126, 16, 256, 256);
            context.m_280163_(WINDOW_TEXTURE, 8, 52, 0.0f, 8.0f, 126, 26, 256, 256);
            context.m_280163_(WINDOW_TEXTURE, this.f_96543_ - 8 - 126 + 1, 36, 126.0f, 0.0f, 126, 16, 256, 256);
            context.m_280163_(WINDOW_TEXTURE, this.f_96543_ - 8 - 126 + 1, 52, 126.0f, 8.0f, 126, 26, 256, 256);
            context.m_280411_(WINDOW_TEXTURE, 134, 36, this.f_96543_ - 16 - 252 + 1, 16, 125.0f, 0.0f, 2, 16, 256, 256);
            context.m_280411_(WINDOW_TEXTURE, 134, 52, this.f_96543_ - 16 - 252 + 1, 54, 125.0f, 8.0f, 2, 54, 256, 256);
        } else {
            context.m_280163_(WINDOW_TEXTURE, 8, 36, 0.0f, 0.0f, 126, 42, 256, 256);
            context.m_280163_(WINDOW_TEXTURE, this.f_96543_ - 8 - 126 + 1, 36, 126.0f, 0.0f, 126, 42, 256, 256);
            context.m_280411_(WINDOW_TEXTURE, 134, 36, this.f_96543_ - 16 - 252 + 1, 70, 125.0f, 0.0f, 2, 70, 256, 256);
        }
        MutableComponent tmpText = SkillsMod.createTranslatable("text", "skills", new Object[0]);
        int tmpX = 16;
        int tmpY = 42;
        context.m_280614_(this.f_96547_, (Component)tmpText, tmpX, tmpY, -12566464, false);
        this.optActiveCategory.ifPresent(activeCategory -> this.drawWindowWithCategory(context, mouseX, mouseY, (Component)tmpText, tmpX, tmpY, (ClientSkillCategoryData)activeCategory));
    }

    private void drawWindowWithCategory(GuiGraphics context, double mouseX, double mouseY, Component tmpText, int tmpX, int tmpY, ClientSkillCategoryData activeCategory) {
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        int leftX = tmpX + this.f_96547_.m_92852_((FormattedText)tmpText);
        int startX = tmpX = this.f_96543_ - 8 - 7;
        tmpText = Component.m_237113_((String)(activeCategory.getPointsLeft() + (String)(activeCategory.getSpentPointsLimit() == Integer.MAX_VALUE ? "" : "/" + activeCategory.getSpentPointsLeft())));
        tmpX -= this.f_96547_.m_92852_((FormattedText)tmpText);
        context.m_280614_(this.f_96547_, tmpText, --tmpX - 1, tmpY, -16777216, false);
        context.m_280614_(this.f_96547_, tmpText, tmpX, tmpY - 1, -16777216, false);
        context.m_280614_(this.f_96547_, tmpText, tmpX + 1, tmpY, -16777216, false);
        context.m_280614_(this.f_96547_, tmpText, tmpX, tmpY + 1, -16777216, false);
        context.m_280614_(this.f_96547_, tmpText, tmpX, tmpY, -8323296, false);
        --tmpX;
        tmpText = SkillsMod.createTranslatable("text", "points_left", new Object[0]);
        context.m_280614_(this.f_96547_, tmpText, tmpX -= this.f_96547_.m_92852_((FormattedText)tmpText), tmpY, -12566464, false);
        Objects.requireNonNull(this.f_96547_);
        if (this.isInsideArea(mouse, tmpX, tmpY, startX, tmpY + 9)) {
            ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
            lines.add(SkillsMod.createTranslatable("tooltip", "earned_points", activeCategory.getEarnedPoints()).m_7532_());
            lines.add(SkillsMod.createTranslatable("tooltip", "spent_points", activeCategory.getSpentPoints() + (String)(activeCategory.getSpentPointsLimit() == Integer.MAX_VALUE ? "" : "/" + activeCategory.getSpentPointsLimit())).m_7532_());
            this.m_257959_(lines);
        }
        int rightX = tmpX;
        if (activeCategory.hasExperience()) {
            if (this.small) {
                tmpX = this.f_96543_ - 8 - 8 - 182;
                tmpY = 53;
            } else {
                tmpX = (leftX + rightX - 182) / 2;
                tmpY = 43;
            }
            context.m_280218_(ICONS_TEXTURE, tmpX, tmpY, 0, 64, 182, 5);
            int width = Math.min(182, (int)(activeCategory.getExperienceProgress() * 183.0f));
            if (width > 0) {
                context.m_280218_(ICONS_TEXTURE, tmpX, tmpY, 0, 69, width, 5);
            }
            if (this.isInsideExperience(mouse, tmpX, tmpY)) {
                ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
                lines.add(SkillsMod.createTranslatable("tooltip", "current_level", activeCategory.getCurrentLevel()).m_7532_());
                lines.add(SkillsMod.createTranslatable("tooltip", "experience_progress", activeCategory.getCurrentExperience(), activeCategory.getRequiredExperience(), Mth.m_14143_((float)(activeCategory.getExperienceProgress() * 100.0f))).m_7532_());
                lines.add(SkillsMod.createTranslatable("tooltip", "to_next_level", activeCategory.getExperienceToNextLevel()).m_7532_());
                this.m_257959_(lines);
            }
        }
    }
}

