/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.data;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.client.data.ClientIconData;
import net.puffish.skillsmod.client.data.ClientSkillConnectionData;
import net.puffish.skillsmod.client.data.ClientSkillData;
import net.puffish.skillsmod.client.data.ClientSkillDefinitionData;
import net.puffish.skillsmod.skill.SkillState;
import net.puffish.skillsmod.utils.Bounds2i;
import org.joml.Vector2i;

public class ClientSkillCategoryData {
    private final ResourceLocation id;
    private final Component title;
    private final ClientIconData icon;
    private final ResourceLocation background;
    private final boolean exclusiveRoot;
    private final int spentPointsLimit;
    private final Map<String, ClientSkillDefinitionData> definitions;
    private final Map<String, ClientSkillData> skills;
    private final Map<String, Collection<String>> normalNeighbors;
    private final Collection<ClientSkillConnectionData> normalConnections;
    private final Map<String, Collection<String>> exclusiveNeighbors;
    private final Map<String, Collection<ClientSkillConnectionData>> exclusiveConnections;
    private final Map<String, Collection<String>> normalNeighborsReversed;
    private final Map<String, Collection<String>> exclusiveNeighborsReversed;
    private int spentPoints;
    private int earnedPoints;
    private int currentLevel;
    private int currentExperience;
    private int requiredExperience;

    public ClientSkillCategoryData(ResourceLocation id, Component title, ClientIconData icon, ResourceLocation background, boolean exclusiveRoot, int spentPointsLimit, Map<String, ClientSkillDefinitionData> definitions, Map<String, ClientSkillData> skills, Collection<ClientSkillConnectionData> normalConnections, Collection<ClientSkillConnectionData> exclusiveConnections, int spentPoints, int earnedPoints, int currentLevel, int currentExperience, int requiredExperience) {
        String b;
        String a;
        this.id = id;
        this.title = title;
        this.icon = icon;
        this.background = background;
        this.exclusiveRoot = exclusiveRoot;
        this.spentPointsLimit = spentPointsLimit;
        this.definitions = definitions;
        this.skills = skills;
        this.normalConnections = normalConnections;
        this.spentPoints = spentPoints;
        this.earnedPoints = earnedPoints;
        this.currentLevel = currentLevel;
        this.currentExperience = currentExperience;
        this.requiredExperience = requiredExperience;
        this.normalNeighbors = new HashMap<String, Collection<String>>();
        this.exclusiveNeighbors = new HashMap<String, Collection<String>>();
        this.exclusiveConnections = new HashMap<String, Collection<ClientSkillConnectionData>>();
        this.normalNeighborsReversed = new HashMap<String, Collection<String>>();
        this.exclusiveNeighborsReversed = new HashMap<String, Collection<String>>();
        for (ClientSkillConnectionData connection : normalConnections) {
            a = connection.getSkillAId();
            b = connection.getSkillBId();
            this.normalNeighbors.computeIfAbsent(a, key -> new HashSet()).add(b);
            this.normalNeighborsReversed.computeIfAbsent(b, key -> new HashSet()).add(a);
            if (!connection.isBidirectional()) continue;
            this.normalNeighbors.computeIfAbsent(b, key -> new HashSet()).add(a);
            this.normalNeighborsReversed.computeIfAbsent(a, key -> new HashSet()).add(b);
        }
        for (ClientSkillConnectionData connection : exclusiveConnections) {
            a = connection.getSkillAId();
            b = connection.getSkillBId();
            this.exclusiveNeighbors.computeIfAbsent(a, key -> new HashSet()).add(b);
            this.exclusiveNeighborsReversed.computeIfAbsent(b, key -> new HashSet()).add(a);
            if (connection.isBidirectional()) {
                this.exclusiveNeighbors.computeIfAbsent(b, key -> new HashSet()).add(a);
                this.exclusiveNeighborsReversed.computeIfAbsent(a, key -> new HashSet()).add(b);
            }
            this.exclusiveConnections.computeIfAbsent(a, key -> new HashSet()).add(connection);
            this.exclusiveConnections.computeIfAbsent(b, key -> new HashSet()).add(connection);
        }
    }

    public Bounds2i getBounds() {
        Bounds2i bounds = Bounds2i.zero();
        for (ClientSkillData skill : this.skills.values()) {
            bounds.extend(new Vector2i(skill.getX(), skill.getY()));
        }
        return bounds;
    }

    public void unlock(String skillId) {
        Collection<String> exclusiveNeighborsIds;
        Collection<String> normalNeighborsIds;
        ClientSkillData skill = this.skills.get(skillId);
        if (skill == null) {
            return;
        }
        skill.setState(SkillState.UNLOCKED);
        if (skill.isRoot() && this.exclusiveRoot) {
            this.skills.values().stream().filter(ClientSkillData::isRoot).filter(other -> other.getState() == SkillState.AVAILABLE).forEach(other -> other.setState(SkillState.LOCKED));
        }
        if ((normalNeighborsIds = this.normalNeighbors.get(skillId)) != null) {
            normalNeighborsIds.stream().map(this.skills::get).filter(Objects::nonNull).filter(neighbor -> neighbor.getState() == SkillState.LOCKED).forEach(neighbor -> neighbor.setState(SkillState.AVAILABLE));
        }
        if ((exclusiveNeighborsIds = this.exclusiveNeighbors.get(skillId)) != null) {
            exclusiveNeighborsIds.stream().map(this.skills::get).filter(Objects::nonNull).filter(neighbor -> neighbor.getState() != SkillState.UNLOCKED).forEach(neighbor -> neighbor.setState(SkillState.EXCLUDED));
        }
    }

    public void lock(String skillId) {
        Collection<String> exclusiveNeighborsIds;
        Collection<String> normalNeighborsIds;
        ClientSkillData skill = this.skills.get(skillId);
        if (skill == null) {
            return;
        }
        if (this.isExcluded(skill)) {
            skill.setState(SkillState.EXCLUDED);
        } else if (this.isAvailable(skill)) {
            skill.setState(SkillState.AVAILABLE);
        } else {
            skill.setState(SkillState.LOCKED);
        }
        if (skill.isRoot() && this.exclusiveRoot && this.skills.values().stream().filter(ClientSkillData::isRoot).allMatch(other -> other.getState() != SkillState.UNLOCKED)) {
            this.skills.values().stream().filter(ClientSkillData::isRoot).filter(other -> other.getState() == SkillState.LOCKED).forEach(other -> other.setState(SkillState.AVAILABLE));
        }
        if ((normalNeighborsIds = this.normalNeighbors.get(skillId)) != null) {
            normalNeighborsIds.stream().map(this.skills::get).filter(Objects::nonNull).filter(neighbor -> neighbor.getState() == SkillState.AVAILABLE).forEach(neighbor -> {
                if (!this.isAvailable((ClientSkillData)neighbor)) {
                    neighbor.setState(SkillState.LOCKED);
                }
            });
        }
        if ((exclusiveNeighborsIds = this.exclusiveNeighbors.get(skillId)) != null) {
            exclusiveNeighborsIds.stream().map(this.skills::get).filter(Objects::nonNull).filter(neighbor -> neighbor.getState() == SkillState.EXCLUDED).forEach(neighbor -> {
                if (!this.isExcluded((ClientSkillData)neighbor)) {
                    if (this.isAvailable((ClientSkillData)neighbor)) {
                        neighbor.setState(SkillState.AVAILABLE);
                    } else {
                        neighbor.setState(SkillState.LOCKED);
                    }
                }
            });
        }
    }

    private boolean isExcluded(ClientSkillData skill) {
        Collection<String> exclusiveNeighborsReversedIds = this.exclusiveNeighborsReversed.get(skill.getId());
        if (exclusiveNeighborsReversedIds == null) {
            return false;
        }
        return exclusiveNeighborsReversedIds.stream().map(this.skills::get).filter(Objects::nonNull).anyMatch(neighbor -> neighbor.getState() == SkillState.UNLOCKED);
    }

    private boolean isAvailable(ClientSkillData skill) {
        if (skill.isRoot()) {
            return !this.exclusiveRoot || this.skills.values().stream().filter(ClientSkillData::isRoot).allMatch(other -> other.getState() != SkillState.UNLOCKED);
        }
        Collection<String> normalNeighborsReversedIds = this.normalNeighborsReversed.get(skill.getId());
        if (normalNeighborsReversedIds == null) {
            return false;
        }
        return normalNeighborsReversedIds.stream().map(this.skills::get).filter(Objects::nonNull).anyMatch(neighbor -> neighbor.getState() == SkillState.UNLOCKED);
    }

    public boolean hasAvailableSkill() {
        return this.skills.values().stream().anyMatch(skill -> skill.getState() == SkillState.AVAILABLE);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Map<String, ClientSkillDefinitionData> getDefinitions() {
        return this.definitions;
    }

    public Map<String, ClientSkillData> getSkills() {
        return this.skills;
    }

    public Collection<ClientSkillConnectionData> getNormalConnections() {
        return this.normalConnections;
    }

    public Map<String, Collection<ClientSkillConnectionData>> getExclusiveConnections() {
        return this.exclusiveConnections;
    }

    public Component getTitle() {
        return this.title;
    }

    public ClientIconData getIcon() {
        return this.icon;
    }

    public ResourceLocation getBackground() {
        return this.background;
    }

    public int getPointsLeft() {
        return Math.max(Math.min(this.earnedPoints, this.spentPointsLimit) - this.spentPoints, 0);
    }

    public int getSpentPoints() {
        return this.spentPoints;
    }

    public void setSpentPoints(int spentPoints) {
        this.spentPoints = spentPoints;
    }

    public int getEarnedPoints() {
        return this.earnedPoints;
    }

    public void setEarnedPoints(int earnedPoints) {
        this.earnedPoints = earnedPoints;
    }

    public int getSpentPointsLeft() {
        return Math.max(this.spentPointsLimit - this.spentPoints, 0);
    }

    public int getSpentPointsLimit() {
        return this.spentPointsLimit;
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public boolean hasExperience() {
        return this.currentLevel >= 0;
    }

    public void setCurrentLevel(int currentLevel) {
        this.currentLevel = currentLevel;
    }

    public int getCurrentExperience() {
        return this.currentExperience;
    }

    public void setCurrentExperience(int currentExperience) {
        this.currentExperience = currentExperience;
    }

    public int getRequiredExperience() {
        return this.requiredExperience;
    }

    public void setRequiredExperience(int requiredExperience) {
        this.requiredExperience = requiredExperience;
    }

    public float getExperienceProgress() {
        return (float)this.currentExperience / (float)this.requiredExperience;
    }

    public int getExperienceToNextLevel() {
        return this.requiredExperience - this.currentExperience;
    }
}

