/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.data;

import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClientIconData {

    public static class TextureIconData
    implements ClientIconData {
        private final ResourceLocation texture;

        private TextureIconData(ResourceLocation texture) {
            this.texture = texture;
        }

        public static Result<TextureIconData, Failure> parse(JsonElementWrapper rootElement) {
            return rootElement.getAsObject().andThen(rootObject -> rootObject.get("texture")).andThen(JsonParseUtils::parseIdentifier).mapSuccess(TextureIconData::new);
        }

        public static TextureIconData createMissing() {
            return new TextureIconData(TextureManager.f_118466_);
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }
    }

    public static class EffectIconData
    implements ClientIconData {
        private final MobEffect effect;

        private EffectIconData(MobEffect effect) {
            this.effect = effect;
        }

        public static Result<EffectIconData, Failure> parse(JsonElementWrapper rootElement) {
            return rootElement.getAsObject().andThen(rootObject -> rootObject.get("effect")).andThen(JsonParseUtils::parseEffect).mapSuccess(EffectIconData::new);
        }

        public MobEffect getEffect() {
            return this.effect;
        }
    }

    public static class ItemIconData
    implements ClientIconData {
        private final ItemStack item;

        private ItemIconData(ItemStack item) {
            this.item = item;
        }

        public static Result<ItemIconData, Failure> parse(JsonElementWrapper rootElement) {
            return JsonParseUtils.parseItemStack(rootElement).mapSuccess(ItemIconData::new);
        }

        public ItemStack getItem() {
            return this.item;
        }
    }
}

