/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.data;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.advancements.FrameType;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClientFrameData {

    public static class TextureFrameData
    implements ClientFrameData {
        private final ResourceLocation availableTexture;
        private final ResourceLocation unlockedTexture;
        private final ResourceLocation lockedTexture;
        private final ResourceLocation excludedTexture;

        public TextureFrameData(ResourceLocation availableTexture, ResourceLocation unlockedTexture, ResourceLocation lockedTexture, ResourceLocation excludedTexture) {
            this.availableTexture = availableTexture;
            this.unlockedTexture = unlockedTexture;
            this.lockedTexture = lockedTexture;
            this.excludedTexture = excludedTexture;
        }

        public static Result<TextureFrameData, Failure> parse(JsonElementWrapper rootElement) {
            return rootElement.getAsObject().andThen(TextureFrameData::parse);
        }

        private static Result<TextureFrameData, Failure> parse(JsonObjectWrapper rootObject) {
            ArrayList<Failure> failures = new ArrayList<Failure>();
            Optional optAvailableTexture = rootObject.get("available").andThen(JsonParseUtils::parseIdentifier).ifFailure(failures::add).getSuccess();
            Optional optUnlockedTexture = rootObject.get("unlocked").andThen(JsonParseUtils::parseIdentifier).ifFailure(failures::add).getSuccess();
            ResourceLocation lockedTexture = rootObject.get("locked").andThen(JsonParseUtils::parseIdentifier).getSuccess().orElse(null);
            ResourceLocation excludedTexture = rootObject.get("excluded").andThen(JsonParseUtils::parseIdentifier).getSuccess().orElse(null);
            if (failures.isEmpty()) {
                return Result.success(new TextureFrameData((ResourceLocation)optAvailableTexture.orElseThrow(), (ResourceLocation)optUnlockedTexture.orElseThrow(), lockedTexture, excludedTexture));
            }
            return Result.failure(Failure.fromMany(failures));
        }

        public static TextureFrameData createMissing() {
            return new TextureFrameData(TextureManager.f_118466_, TextureManager.f_118466_, TextureManager.f_118466_, TextureManager.f_118466_);
        }

        public ResourceLocation getLockedTexture() {
            return this.lockedTexture;
        }

        public ResourceLocation getAvailableTexture() {
            return this.availableTexture;
        }

        public ResourceLocation getUnlockedTexture() {
            return this.unlockedTexture;
        }

        public ResourceLocation getExcludedTexture() {
            return this.excludedTexture;
        }
    }

    public static class AdvancementFrameData
    implements ClientFrameData {
        private final FrameType frame;

        private AdvancementFrameData(FrameType frame) {
            this.frame = frame;
        }

        public static Result<AdvancementFrameData, Failure> parse(JsonElementWrapper rootElement) {
            return rootElement.getAsObject().andThen(rootObject -> rootObject.get("frame")).andThen(JsonParseUtils::parseFrame).mapSuccess(AdvancementFrameData::new);
        }

        public FrameType getFrame() {
            return this.frame;
        }
    }
}

