/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.utils;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.Result;

public class JsonParseUtils {
    public static Result<ResourceLocation, Failure> parseIdentifier(JsonElementWrapper element) {
        try {
            return Result.success(new ResourceLocation(GsonHelper.m_13805_((JsonElement)element.getJson(), (String)"")));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid identifier"));
        }
    }

    public static Result<String, Failure> parseIdentifierPath(JsonElementWrapper element) {
        try {
            return Result.success(new ResourceLocation("minecraft", GsonHelper.m_13805_((JsonElement)element.getJson(), (String)"")).m_135815_());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid identifier path"));
        }
    }

    public static Result<MobEffect, Failure> parseEffect(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (MobEffect)BuiltInRegistries.f_256974_.m_6612_(id).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid effect"));
        }
    }

    public static Result<Block, Failure> parseBlock(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (Block)BuiltInRegistries.f_256975_.m_6612_(id).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid block"));
        }
    }

    public static Result<StatePropertiesPredicate, Failure> parseStatePredicate(JsonElementWrapper element) {
        try {
            return Result.success(StatePropertiesPredicate.m_67679_((JsonElement)element.getJson()));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid state predicate"));
        }
    }

    public static Result<NbtPredicate, Failure> parseNbtPredicate(JsonElementWrapper element) {
        try {
            return Result.success(NbtPredicate.m_57481_((JsonElement)element.getJson()));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid state predicate"));
        }
    }

    public static Result<HolderSet.Named<Block>, Failure> parseBlockTag(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (HolderSet.Named)BuiltInRegistries.f_256975_.m_255014_().m_254901_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)id)).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid block tag"));
        }
    }

    public static Result<DamageType, Failure> parseDamageType(JsonElementWrapper element, RegistryAccess manager) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (DamageType)manager.m_175515_(Registries.f_268580_).m_6612_(id).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid damage type"));
        }
    }

    public static Result<HolderSet.Named<DamageType>, Failure> parseDamageTypeTag(JsonElementWrapper element, RegistryAccess manager) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (HolderSet.Named)manager.m_175515_(Registries.f_268580_).m_255014_().m_254901_(TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)id)).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid damage type tag"));
        }
    }

    public static Result<EntityType<?>, Failure> parseEntityType(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (EntityType)BuiltInRegistries.f_256780_.m_6612_(id).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid entity type"));
        }
    }

    public static Result<HolderSet.Named<EntityType<?>>, Failure> parseEntityTypeTag(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (HolderSet.Named)BuiltInRegistries.f_256780_.m_255014_().m_254901_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)id)).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid entity type tag"));
        }
    }

    public static Result<Stat<?>, Failure> parseStat(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> JsonParseUtils.getOrCreateStat((StatType)BuiltInRegistries.f_256899_.m_6612_(ResourceLocation.m_135822_((String)id.m_135827_(), (char)'.')).orElseThrow(), ResourceLocation.m_135822_((String)id.m_135815_(), (char)'.')));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid statistic"));
        }
    }

    private static <T> Stat<T> getOrCreateStat(StatType<T> statType, ResourceLocation id) {
        return statType.m_12902_(statType.m_12893_().m_6612_(id).orElseThrow());
    }

    public static Result<Item, Failure> parseItem(JsonElementWrapper element) {
        try {
            return Result.success(GsonHelper.m_13874_((JsonElement)element.getJson(), (String)""));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid item"));
        }
    }

    public static Result<HolderSet.Named<Item>, Failure> parseItemTag(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (HolderSet.Named)BuiltInRegistries.f_257033_.m_255014_().m_254901_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)id)).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid item tag"));
        }
    }

    public static Result<CompoundTag, Failure> parseNbt(JsonElementWrapper element) {
        try {
            return Result.success(TagParser.m_129359_((String)GsonHelper.m_13805_((JsonElement)element.getJson(), (String)"")));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid nbt"));
        }
    }

    public static Result<ItemStack, Failure> parseItemStack(JsonElementWrapper element) {
        try {
            return element.getAsObject().andThen(object -> {
                ArrayList<Failure> failures = new ArrayList<Failure>();
                Optional item = object.get("item").andThen(JsonParseUtils::parseItem).ifFailure(failures::add).getSuccess();
                Optional nbt = object.get("nbt").getSuccess().flatMap(nbtElement -> JsonParseUtils.parseNbt(nbtElement).ifFailure(failures::add).getSuccess());
                if (failures.isEmpty()) {
                    ItemStack itemStack = new ItemStack((ItemLike)item.orElseThrow());
                    nbt.ifPresent(arg_0 -> ((ItemStack)itemStack).m_41751_(arg_0));
                    return Result.success(itemStack);
                }
                return Result.failure(Failure.fromMany(failures));
            });
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid item stack"));
        }
    }

    public static Result<FrameType, Failure> parseFrame(JsonElementWrapper element) {
        try {
            return element.getAsString().andThen(name -> Result.success(FrameType.m_15549_((String)name)));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid frame"));
        }
    }

    public static Result<Component, Failure> parseText(JsonElementWrapper element) {
        try {
            return Result.success(Component.Serializer.m_130691_((JsonElement)element.getJson()));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid text"));
        }
    }

    public static Result<Attribute, Failure> parseAttribute(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (Attribute)BuiltInRegistries.f_256951_.m_6612_(id).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid attribute"));
        }
    }

    public static Result<AttributeModifier.Operation, Failure> parseAttributeOperation(JsonElementWrapper element) {
        return element.getAsString().andThen(string -> switch (string) {
            case "addition" -> Result.success(AttributeModifier.Operation.ADDITION);
            case "multiply_base" -> Result.success(AttributeModifier.Operation.MULTIPLY_BASE);
            case "multiply_total" -> Result.success(AttributeModifier.Operation.MULTIPLY_TOTAL);
            default -> Result.failure(element.getPath().createFailure("Expected valid attribute operation"));
        });
    }
}

