/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.experience.calculation.parameter;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.calculation.parameter.Parameter;
import net.puffish.skillsmod.api.experience.calculation.parameter.ParameterFactory;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;

public class EffectParameter
implements Parameter<LivingEntity> {
    private final MobEffect effect;

    private EffectParameter(MobEffect effect) {
        this.effect = effect;
    }

    public static ParameterFactory<LivingEntity> factory() {
        return ParameterFactory.withData(EffectParameter::parse);
    }

    public static Result<EffectParameter, Failure> parse(JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(EffectParameter::parse);
    }

    public static Result<EffectParameter, Failure> parse(JsonObjectWrapper rootObject) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional optEffect = rootObject.get("effect").andThen(JsonParseUtils::parseEffect).ifFailure(failures::add).getSuccess();
        if (failures.isEmpty()) {
            return Result.success(new EffectParameter((MobEffect)optEffect.orElseThrow()));
        }
        return Result.failure(Failure.fromMany(failures));
    }

    @Override
    public Double apply(LivingEntity entity) {
        MobEffectInstance instance = entity.m_21124_(this.effect);
        if (instance == null) {
            return 0.0;
        }
        return (double)instance.m_19564_() + 1.0;
    }
}

