/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.experience.calculation.parameter;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.calculation.parameter.Parameter;
import net.puffish.skillsmod.api.experience.calculation.parameter.ParameterFactory;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;

public class AttributeParameter
implements Parameter<LivingEntity> {
    private final Attribute attribute;

    private AttributeParameter(Attribute attribute) {
        this.attribute = attribute;
    }

    public static ParameterFactory<LivingEntity> factory() {
        return ParameterFactory.withData(AttributeParameter::parse);
    }

    public static Result<AttributeParameter, Failure> parse(JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(AttributeParameter::parse);
    }

    public static Result<AttributeParameter, Failure> parse(JsonObjectWrapper rootObject) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional optAttribute = rootObject.get("attribute").andThen(JsonParseUtils::parseAttribute).ifFailure(failures::add).getSuccess();
        if (failures.isEmpty()) {
            return Result.success(new AttributeParameter((Attribute)optAttribute.orElseThrow()));
        }
        return Result.failure(Failure.fromMany(failures));
    }

    @Override
    public Double apply(LivingEntity entity) {
        AttributeInstance instance = entity.m_21051_(this.attribute);
        if (instance == null) {
            return this.attribute.m_22082_();
        }
        return instance.m_22135_();
    }
}

