/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.experience.calculation.condition;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.damagesource.DamageType;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.calculation.condition.Condition;
import net.puffish.skillsmod.api.experience.calculation.condition.ConditionFactory;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;

public final class DamageTypeTagCondition
implements Condition<Holder<DamageType>> {
    private final HolderSet.Named<DamageType> entries;

    private DamageTypeTagCondition(HolderSet.Named<DamageType> entries) {
        this.entries = entries;
    }

    public static ConditionFactory<Holder<DamageType>> factory() {
        return ConditionFactory.withData(DamageTypeTagCondition::parse);
    }

    public static Result<DamageTypeTagCondition, Failure> parse(JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(rootObject -> DamageTypeTagCondition.parse(rootObject, context));
    }

    public static Result<DamageTypeTagCondition, Failure> parse(JsonObjectWrapper rootObject, ConfigContext context) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional optTag = rootObject.get("tag").andThen(element -> JsonParseUtils.parseDamageTypeTag(element, context.getDynamicRegistryManager())).ifFailure(failures::add).getSuccess();
        if (failures.isEmpty()) {
            return Result.success(new DamageTypeTagCondition((HolderSet.Named<DamageType>)((HolderSet.Named)optTag.orElseThrow())));
        }
        return Result.failure(Failure.fromMany(failures));
    }

    @Override
    public boolean test(Holder<DamageType> damageType) {
        return this.entries.m_203333_(damageType);
    }
}

