/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.experience.calculation.condition;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageType;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.calculation.condition.Condition;
import net.puffish.skillsmod.api.experience.calculation.condition.ConditionFactory;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;

public final class DamageTypeCondition
implements Condition<Holder<DamageType>> {
    private final DamageType damageType;

    private DamageTypeCondition(DamageType damageType) {
        this.damageType = damageType;
    }

    public static ConditionFactory<Holder<DamageType>> factory() {
        return ConditionFactory.withData(DamageTypeCondition::parse);
    }

    public static Result<DamageTypeCondition, Failure> parse(JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(rootObject -> DamageTypeCondition.parse(rootObject, context));
    }

    public static Result<DamageTypeCondition, Failure> parse(JsonObjectWrapper rootObject, ConfigContext context) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional optDamage = rootObject.get("damage").andThen(damageElement -> JsonParseUtils.parseDamageType(damageElement, context.getDynamicRegistryManager())).ifFailure(failures::add).getSuccess();
        if (failures.isEmpty()) {
            return Result.success(new DamageTypeCondition((DamageType)optDamage.orElseThrow()));
        }
        return Result.failure(Failure.fromMany(failures));
    }

    @Override
    public boolean test(Holder<DamageType> damageType) {
        return this.damageType == damageType.m_203334_();
    }
}

