/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.experience.calculation.condition;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.world.level.block.state.BlockState;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.calculation.condition.Condition;
import net.puffish.skillsmod.api.experience.calculation.condition.ConditionFactory;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;

public final class BlockStateCondition
implements Condition<BlockState> {
    private final StatePropertiesPredicate state;

    private BlockStateCondition(StatePropertiesPredicate state) {
        this.state = state;
    }

    public static ConditionFactory<BlockState> factory() {
        return ConditionFactory.withData(BlockStateCondition::parse);
    }

    public static Result<BlockStateCondition, Failure> parse(JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(BlockStateCondition::parse);
    }

    public static Result<BlockStateCondition, Failure> parse(JsonObjectWrapper rootObject) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional optState = rootObject.get("state").andThen(JsonParseUtils::parseStatePredicate).ifFailure(failures::add).getSuccess();
        if (failures.isEmpty()) {
            return Result.success(new BlockStateCondition((StatePropertiesPredicate)optState.orElseThrow()));
        }
        return Result.failure(Failure.fromMany(failures));
    }

    @Override
    public boolean test(BlockState blockState) {
        return this.state.m_67667_(blockState);
    }
}

