/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.experience.calculation.condition;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.calculation.condition.Condition;
import net.puffish.skillsmod.api.experience.calculation.condition.ConditionFactory;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;

public final class BlockCondition
implements Condition<BlockState> {
    private final Block block;
    private final Optional<StatePropertiesPredicate> optState;

    private BlockCondition(Block block, Optional<StatePropertiesPredicate> optState) {
        this.block = block;
        this.optState = optState;
    }

    public static ConditionFactory<BlockState> factory() {
        return ConditionFactory.withData(BlockCondition::parse);
    }

    public static Result<BlockCondition, Failure> parse(JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(BlockCondition::parse);
    }

    public static Result<BlockCondition, Failure> parse(JsonObjectWrapper rootObject) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional optBlock = rootObject.get("block").andThen(JsonParseUtils::parseBlock).ifFailure(failures::add).getSuccess();
        Optional<StatePropertiesPredicate> optState = rootObject.get("state").getSuccess().flatMap(stateElement -> JsonParseUtils.parseStatePredicate(stateElement).ifFailure(failures::add).getSuccess());
        if (failures.isEmpty()) {
            return Result.success(new BlockCondition((Block)optBlock.orElseThrow(), optState));
        }
        return Result.failure(Failure.fromMany(failures));
    }

    @Override
    public boolean test(BlockState blockState) {
        return blockState.m_60713_(this.block) && this.optState.map((? super T state) -> state.m_67667_(blockState)).orElse(true) != false;
    }
}

