/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.api.experience.ExperienceSource;
import net.puffish.skillsmod.api.experience.ExperienceSourceWithDataFactory;
import net.puffish.skillsmod.api.experience.ExperienceSourceWithoutDataFactory;
import net.puffish.skillsmod.api.rewards.RewardWithDataFactory;
import net.puffish.skillsmod.api.rewards.RewardWithoutDataFactory;
import net.puffish.skillsmod.experience.ExperienceSourceRegistry;
import net.puffish.skillsmod.impl.CategoryImpl;
import net.puffish.skillsmod.rewards.RewardRegistry;

public class SkillsAPI {
    public static final String MOD_ID = "puffish_skills";

    public static void registerRewardWithData(ResourceLocation key, RewardWithDataFactory factory) {
        RewardRegistry.register(key, factory);
    }

    public static void registerRewardWithoutData(ResourceLocation key, RewardWithoutDataFactory factory) {
        RewardRegistry.register(key, factory);
    }

    public static void refreshReward(ServerPlayer player, ResourceLocation key) {
        SkillsMod.getInstance().refreshReward(player, key);
    }

    public static void registerExperienceSourceWithData(ResourceLocation key, ExperienceSourceWithDataFactory factory) {
        ExperienceSourceRegistry.register(key, factory);
    }

    public static void registerExperienceSourceWithoutData(ResourceLocation key, ExperienceSourceWithoutDataFactory factory) {
        ExperienceSourceRegistry.register(key, factory);
    }

    public static void visitExperienceSources(ServerPlayer player, Function<ExperienceSource, Integer> function) {
        SkillsMod.getInstance().visitExperienceSources(player, function);
    }

    public static void openScreen(ServerPlayer player) {
        SkillsMod.getInstance().openScreen(player, Optional.empty());
    }

    public static Optional<Category> getCategory(ResourceLocation categoryId) {
        if (SkillsMod.getInstance().hasCategory(categoryId)) {
            return Optional.of(new CategoryImpl(categoryId));
        }
        return Optional.empty();
    }

    public static List<Category> getCategories() {
        return SkillsMod.getInstance().getCategories(false).stream().map(id -> new CategoryImpl((ResourceLocation)id)).toList();
    }

    public static List<Category> getUnlockedCategories(ServerPlayer player) {
        return SkillsMod.getInstance().getUnlockedCategories(player).stream().map(id -> new CategoryImpl((ResourceLocation)id)).toList();
    }
}

