/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.puffish.skillsmod.api.experience.ExperienceSource;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.commands.CategoryCommand;
import net.puffish.skillsmod.commands.ExperienceCommand;
import net.puffish.skillsmod.commands.OpenCommand;
import net.puffish.skillsmod.commands.PointsCommand;
import net.puffish.skillsmod.commands.SkillsCommand;
import net.puffish.skillsmod.config.CategoryConfig;
import net.puffish.skillsmod.config.ModConfig;
import net.puffish.skillsmod.config.PackConfig;
import net.puffish.skillsmod.config.experience.ExperienceSourceConfig;
import net.puffish.skillsmod.config.reader.ConfigReader;
import net.puffish.skillsmod.config.reader.FileConfigReader;
import net.puffish.skillsmod.config.reader.PackConfigReader;
import net.puffish.skillsmod.config.skill.SkillConfig;
import net.puffish.skillsmod.config.skill.SkillDefinitionConfig;
import net.puffish.skillsmod.config.skill.SkillRewardConfig;
import net.puffish.skillsmod.experience.builtin.CraftItemExperienceSource;
import net.puffish.skillsmod.experience.builtin.EatFoodExperienceSource;
import net.puffish.skillsmod.experience.builtin.IncreaseStatExperienceSource;
import net.puffish.skillsmod.experience.builtin.KillEntityExperienceSource;
import net.puffish.skillsmod.experience.builtin.MineBlockExperienceSource;
import net.puffish.skillsmod.experience.builtin.TakeDamageExperienceSource;
import net.puffish.skillsmod.impl.config.ConfigContextImpl;
import net.puffish.skillsmod.impl.rewards.RewardContextImpl;
import net.puffish.skillsmod.network.Packets;
import net.puffish.skillsmod.rewards.builtin.AttributeReward;
import net.puffish.skillsmod.rewards.builtin.CommandReward;
import net.puffish.skillsmod.rewards.builtin.ScoreboardReward;
import net.puffish.skillsmod.rewards.builtin.TagReward;
import net.puffish.skillsmod.server.data.CategoryData;
import net.puffish.skillsmod.server.data.PlayerData;
import net.puffish.skillsmod.server.data.ServerData;
import net.puffish.skillsmod.server.event.ServerEventListener;
import net.puffish.skillsmod.server.event.ServerEventReceiver;
import net.puffish.skillsmod.server.network.ServerPacketSender;
import net.puffish.skillsmod.server.network.packets.in.SkillClickInPacket;
import net.puffish.skillsmod.server.network.packets.out.ExperienceUpdateOutPacket;
import net.puffish.skillsmod.server.network.packets.out.HideCategoryOutPacket;
import net.puffish.skillsmod.server.network.packets.out.OpenScreenOutPacket;
import net.puffish.skillsmod.server.network.packets.out.PointsUpdateOutPacket;
import net.puffish.skillsmod.server.network.packets.out.ShowCategoryOutPacket;
import net.puffish.skillsmod.server.network.packets.out.ShowToastOutPacket;
import net.puffish.skillsmod.server.network.packets.out.SkillUpdateOutPacket;
import net.puffish.skillsmod.server.setup.ServerRegistrar;
import net.puffish.skillsmod.server.setup.SkillsArgumentTypes;
import net.puffish.skillsmod.server.setup.SkillsAttributes;
import net.puffish.skillsmod.server.setup.SkillsGameRules;
import net.puffish.skillsmod.skill.SkillState;
import net.puffish.skillsmod.utils.ChangeListener;
import net.puffish.skillsmod.utils.PathUtils;
import net.puffish.skillsmod.utils.PrefixedLogger;
import net.puffish.skillsmod.utils.ToastType;

public class SkillsMod {
    public static final int CONFIG_VERSION = 1;
    private static SkillsMod instance;
    private final PrefixedLogger logger = new PrefixedLogger("puffish_skills");
    private final Path modConfigDir;
    private final ServerPacketSender packetSender;
    private final ChangeListener<Optional<Map<ResourceLocation, CategoryConfig>>> categories = new ChangeListener(Optional.empty(), () -> {});

    private SkillsMod(Path modConfigDir, ServerPacketSender packetSender) {
        this.modConfigDir = modConfigDir;
        this.packetSender = packetSender;
    }

    public static SkillsMod getInstance() {
        return instance;
    }

    public static void setup(Path configDir, ServerRegistrar registrar, ServerEventReceiver eventReceiver, ServerPacketSender packetSender) {
        Path modConfigDir = configDir.resolve("puffish_skills");
        try {
            Files.createDirectories(modConfigDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        instance = new SkillsMod(modConfigDir, packetSender);
        registrar.registerInPacket(Packets.SKILL_CLICK, SkillClickInPacket::read, instance::onSkillClickPacket);
        registrar.registerOutPacket(Packets.SHOW_CATEGORY);
        registrar.registerOutPacket(Packets.HIDE_CATEGORY);
        registrar.registerOutPacket(Packets.SKILL_UPDATE);
        registrar.registerOutPacket(Packets.POINTS_UPDATE);
        registrar.registerOutPacket(Packets.EXPERIENCE_UPDATE);
        registrar.registerOutPacket(Packets.SHOW_TOAST);
        registrar.registerOutPacket(Packets.OPEN_SCREEN);
        eventReceiver.registerListener(instance.new EventListener());
        SkillsAttributes.register(registrar);
        SkillsGameRules.register(registrar);
        SkillsArgumentTypes.register(registrar);
        AttributeReward.register();
        CommandReward.register();
        ScoreboardReward.register();
        TagReward.register();
        MineBlockExperienceSource.register();
        KillEntityExperienceSource.register();
        EatFoodExperienceSource.register();
        CraftItemExperienceSource.register();
        TakeDamageExperienceSource.register();
        IncreaseStatExperienceSource.register();
    }

    public static ResourceLocation createIdentifier(String path) {
        return new ResourceLocation("puffish_skills", path);
    }

    public static ResourceLocation convertIdentifier(ResourceLocation id) {
        if (id.m_135827_().equals("minecraft")) {
            return SkillsMod.createIdentifier(id.m_135815_());
        }
        return id;
    }

    public static MutableComponent createTranslatable(String type, String path, Object ... args) {
        return Component.m_237110_((String)Util.m_137492_((String)type, (ResourceLocation)SkillsMod.createIdentifier(path)), (Object[])args);
    }

    public static ResourceLocation createAttribute(String type, String name) {
        return SkillsMod.createIdentifier(type + "." + name);
    }

    public PrefixedLogger getLogger() {
        return this.logger;
    }

    private void copyConfigFromJar() {
        PathUtils.copyFileFromJar(Path.of("config", "config.json"), this.modConfigDir.resolve("config.json"));
        List<String> categories = List.of("combat", "mining");
        List<String> files = List.of("category.json", "definitions.json", "skills.json", "connections.json", "experience.json");
        for (String category : categories) {
            for (String file : files) {
                PathUtils.copyFileFromJar(Path.of("config", "categories", category, file), this.modConfigDir.resolve(Path.of("categories", category, file)));
            }
        }
    }

    private void loadModConfig(MinecraftServer server) {
        if (!Files.exists(this.modConfigDir, new LinkOption[0]) || PathUtils.isDirectoryEmpty(this.modConfigDir)) {
            this.copyConfigFromJar();
        }
        FileConfigReader reader = new FileConfigReader(this.modConfigDir);
        LinkedHashMap cumulatedMap = new LinkedHashMap();
        reader.read(Path.of("config.json", new String[0])).andThen(ModConfig::parse).andThen(modConfig -> this.loadConfig(reader, (ModConfig)modConfig, server).mapSuccess(map -> {
            cumulatedMap.putAll(map);
            return modConfig;
        })).peek(modConfig -> {
            cumulatedMap.putAll(this.loadPackConfig((ModConfig)modConfig, server));
            this.categories.set(Optional.of(cumulatedMap), () -> {
                for (CategoryConfig category : cumulatedMap.values()) {
                    category.dispose(server);
                }
            });
        }, failure -> {
            this.logger.error("Configuration could not be loaded:" + System.lineSeparator() + failure.getMessages().stream().collect(Collectors.joining(System.lineSeparator())));
            this.categories.set(Optional.empty(), () -> {});
        });
    }

    private Result<Map<ResourceLocation, CategoryConfig>, Failure> loadConfig(ConfigReader reader, ModConfig modConfig, MinecraftServer server) {
        ConfigContextImpl context = new ConfigContextImpl(server);
        return reader.readCategories("puffish_skills", modConfig.getCategories(), context).ifSuccess(map -> {
            if (modConfig.getShowWarnings() && !context.warnings().isEmpty()) {
                this.logger.warn("Configuration loaded successfully with warning(s):" + System.lineSeparator() + context.warnings().stream().collect(Collectors.joining(System.lineSeparator())));
            } else {
                this.logger.info("Configuration loaded successfully!");
            }
        });
    }

    private Map<ResourceLocation, CategoryConfig> loadPackConfig(ModConfig modConfig, MinecraftServer server) {
        ConfigContextImpl context = new ConfigContextImpl(server);
        LinkedHashMap<ResourceLocation, CategoryConfig> cumulatedMap = new LinkedHashMap<ResourceLocation, CategoryConfig>();
        Map resources = context.getResourceManager().m_214159_("puffish_skills", id -> id.m_135815_().endsWith("config.json"));
        for (Map.Entry entry : resources.entrySet()) {
            Resource resource = (Resource)entry.getValue();
            ResourceLocation id2 = (ResourceLocation)entry.getKey();
            String name = id2.m_135827_();
            PackConfigReader reader = new PackConfigReader(context.getResourceManager(), name);
            reader.readResource(id2, resource).andThen(rootElement -> PackConfig.parse(name, rootElement)).andThen(packConfig -> reader.readCategories(name, packConfig.getCategories(), context)).peek(map -> {
                if (modConfig.getShowWarnings() && !context.warnings().isEmpty()) {
                    this.logger.warn("Data pack `" + name + "` loaded successfully with warning(s):" + System.lineSeparator() + context.warnings().stream().collect(Collectors.joining(System.lineSeparator())));
                } else {
                    this.logger.info("Data pack `" + name + "` loaded successfully!");
                }
                cumulatedMap.putAll((Map<ResourceLocation, CategoryConfig>)map);
            }, failure -> this.logger.error("Data pack `" + name + "` could not be loaded:" + System.lineSeparator() + failure.getMessages().stream().collect(Collectors.joining(System.lineSeparator()))));
        }
        return cumulatedMap;
    }

    private void onSkillClickPacket(ServerPlayer player, SkillClickInPacket packet) {
        if (player.m_5833_()) {
            return;
        }
        this.tryUnlockSkill(player, packet.getCategoryId(), packet.getSkillId(), false);
    }

    public void unlockSkill(ServerPlayer player, ResourceLocation categoryId, String skillId) {
        this.tryUnlockSkill(player, categoryId, skillId, true);
    }

    private void tryUnlockSkill(ServerPlayer player, ResourceLocation categoryId, String skillId, boolean force) {
        this.getCategory(categoryId).ifPresent(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
            if (categoryData.tryUnlockSkill((CategoryConfig)category, player, skillId, force)) {
                this.packetSender.send(player, SkillUpdateOutPacket.write(categoryId, skillId, true));
                this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
            }
        }));
    }

    public void lockSkill(ServerPlayer player, ResourceLocation categoryId, String skillId) {
        this.getCategory(categoryId).ifPresent(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
            categoryData.lockSkill(skillId);
            this.packetSender.send(player, SkillUpdateOutPacket.write(categoryId, skillId, false));
            this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
        }));
    }

    public void resetSkills(ServerPlayer player, ResourceLocation categoryId) {
        this.getCategory(categoryId).ifPresent(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
            categoryData.resetSkills();
            this.applyRewards(player, (CategoryConfig)category, (CategoryData)categoryData);
            this.syncCategory(player, (CategoryConfig)category, (CategoryData)categoryData);
        }));
    }

    public void eraseCategory(ServerPlayer player, ResourceLocation categoryId) {
        this.getCategory(categoryId).ifPresent(category -> {
            PlayerData playerData = this.getPlayerData(player);
            playerData.removeCategoryData((CategoryConfig)category);
            this.syncCategory(player, (CategoryConfig)category);
        });
    }

    public void unlockCategory(ServerPlayer player, ResourceLocation categoryId) {
        this.getCategory(categoryId).ifPresent(category -> {
            PlayerData playerData = this.getPlayerData(player);
            playerData.unlockCategory((CategoryConfig)category);
            this.syncCategory(player, (CategoryConfig)category);
        });
    }

    public void lockCategory(ServerPlayer player, ResourceLocation categoryId) {
        this.getCategory(categoryId).ifPresent(category -> {
            PlayerData playerData = this.getPlayerData(player);
            playerData.lockCategory((CategoryConfig)category);
            this.syncCategory(player, (CategoryConfig)category);
        });
    }

    public Optional<Boolean> hasExperience(ResourceLocation categoryId) {
        return this.getCategory(categoryId).map(category -> category.getExperience().isPresent());
    }

    public void addExperience(ServerPlayer player, ResourceLocation categoryId, int amount) {
        this.getCategory(categoryId).ifPresent(category -> {
            if (category.getExperience().isEmpty()) {
                return;
            }
            this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
                categoryData.addExperience(amount);
                this.syncExperience(player, (CategoryConfig)category, (CategoryData)categoryData);
                this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
            });
        });
    }

    public void setExperience(ServerPlayer player, ResourceLocation categoryId, int amount) {
        this.getCategory(categoryId).ifPresent(category -> {
            if (category.getExperience().isEmpty()) {
                return;
            }
            this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
                categoryData.setEarnedExperience(amount);
                this.syncExperience(player, (CategoryConfig)category, (CategoryData)categoryData);
                this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
            });
        });
    }

    public Optional<Integer> getExperience(ServerPlayer player, ResourceLocation categoryId) {
        return this.getCategory(categoryId).flatMap(category -> {
            if (category.getExperience().isEmpty()) {
                return Optional.empty();
            }
            return this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).map(CategoryData::getEarnedExperience);
        });
    }

    public void addExtraPoints(ServerPlayer player, ResourceLocation categoryId, int count) {
        this.getCategory(categoryId).ifPresent(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
            categoryData.addExtraPoints(count);
            this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
        }));
    }

    public void setExtraPoints(ServerPlayer player, ResourceLocation categoryId, int count) {
        this.getCategory(categoryId).ifPresent(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
            categoryData.setExtraPoints(count);
            this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
        }));
    }

    public Optional<Integer> getExtraPoints(ServerPlayer player, ResourceLocation categoryId) {
        return this.getCategory(categoryId).flatMap(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).map(CategoryData::getExtraPoints));
    }

    public Optional<Integer> getPointsLeft(ServerPlayer player, ResourceLocation categoryId) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getPointsLeft((CategoryConfig)category);
        });
    }

    public Optional<Integer> getCurrentLevel(ServerPlayer player, ResourceLocation categoryId) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getCurrentLevel((CategoryConfig)category);
        });
    }

    public Optional<Integer> getCurrentExperience(ServerPlayer player, ResourceLocation categoryId) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getCurrentExperience((CategoryConfig)category);
        });
    }

    public Optional<Integer> getRequiredExperience(ServerPlayer player, ResourceLocation categoryId, int level) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getRequiredExperience((CategoryConfig)category, level);
        });
    }

    public Optional<Integer> getRequiredTotalExperience(ServerPlayer player, ResourceLocation categoryId, int level) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getRequiredTotalExperience((CategoryConfig)category, level);
        });
    }

    public Optional<SkillState> getSkillState(ServerPlayer player, ResourceLocation categoryId, String skillId) {
        return this.getCategory(categoryId).flatMap(category -> category.getSkills().getById(skillId).map(skill -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getSkillState((CategoryConfig)category, (SkillConfig)skill);
        }));
    }

    public Collection<ResourceLocation> getUnlockedCategories(ServerPlayer player) {
        PlayerData playerData = this.getPlayerData(player);
        return this.getAllCategories().stream().filter(playerData::isCategoryUnlocked).map(CategoryConfig::getId).toList();
    }

    public Collection<ResourceLocation> getCategories(boolean onlyWithExperience) {
        return this.getAllCategories().stream().filter(category -> !onlyWithExperience || category.getExperience().isPresent()).map(CategoryConfig::getId).toList();
    }

    public Optional<Collection<String>> getUnlockedSkills(ServerPlayer player, ResourceLocation categoryId) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getUnlockedSkillIds();
        });
    }

    public Optional<Collection<String>> getSkills(ResourceLocation categoryId) {
        return this.getCategory(categoryId).map(category -> category.getSkills().getAll().stream().map(SkillConfig::getId).toList());
    }

    public boolean hasCategory(ResourceLocation categoryId) {
        return this.getCategory(categoryId).isPresent();
    }

    public boolean hasSkill(ResourceLocation categoryId, String skillId) {
        return this.getCategory(categoryId).map(category -> category.getSkills().getById(skillId).isPresent()).orElse(false);
    }

    private void showCategory(ServerPlayer player, CategoryConfig category, CategoryData categoryData) {
        this.packetSender.send(player, ShowCategoryOutPacket.write(category, categoryData));
    }

    private void hideCategory(ServerPlayer player, CategoryConfig category) {
        this.packetSender.send(player, HideCategoryOutPacket.write(category.getId()));
    }

    private void syncPoints(ServerPlayer player, CategoryConfig category, CategoryData categoryData) {
        this.packetSender.send(player, PointsUpdateOutPacket.write(category.getId(), categoryData.getSpentPoints(category), categoryData.getEarnedPoints(category), player.m_9236_().m_46469_().m_46207_(SkillsGameRules.ANNOUNCE_NEW_POINTS)));
    }

    private void syncExperience(ServerPlayer player, CategoryConfig category, CategoryData categoryData) {
        int level = categoryData.getCurrentLevel(category);
        this.packetSender.send(player, ExperienceUpdateOutPacket.write(category.getId(), level, categoryData.getCurrentExperience(category), categoryData.getRequiredExperience(category, level)));
    }

    public void refreshReward(ServerPlayer player, ResourceLocation type) {
        for (CategoryConfig category : this.getAllCategories()) {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData(category);
            categoryData.refreshReward(category, player, type);
        }
    }

    public void visitExperienceSources(ServerPlayer player, Function<ExperienceSource, Integer> function) {
        for (CategoryConfig category : this.getAllCategories()) {
            category.getExperience().ifPresent(experience -> this.getCategoryDataIfUnlocked(player, category).ifPresent(categoryData -> {
                int amount = 0;
                for (ExperienceSourceConfig experienceSource : experience.getExperienceSources()) {
                    amount += ((Integer)function.apply(experienceSource.getInstance())).intValue();
                }
                if (amount != 0) {
                    categoryData.addExperience(amount);
                    this.syncExperience(player, category, (CategoryData)categoryData);
                    this.syncPoints(player, category, (CategoryData)categoryData);
                }
            }));
        }
    }

    private void applyRewards(ServerPlayer player, CategoryConfig category, CategoryData categoryData) {
        categoryData.applyRewards(category, player);
    }

    private void resetRewards(ServerPlayer player, CategoryConfig category) {
        for (SkillDefinitionConfig definition : category.getDefinitions().getAll()) {
            for (SkillRewardConfig reward : definition.getRewards()) {
                reward.getInstance().update(player, new RewardContextImpl(0, false));
            }
        }
    }

    private Optional<CategoryData> getCategoryDataIfUnlocked(ServerPlayer player, CategoryConfig category) {
        return this.getCategoryDataIfUnlocked(this.getPlayerData(player), category);
    }

    private Optional<CategoryData> getCategoryDataIfUnlocked(PlayerData playerData, CategoryConfig category) {
        if (playerData.isCategoryUnlocked(category)) {
            return Optional.of(playerData.getCategoryData(category));
        }
        return Optional.empty();
    }

    private Optional<CategoryConfig> getCategory(ResourceLocation categoryId) {
        return this.categories.get().flatMap(map -> Optional.ofNullable((CategoryConfig)map.get(categoryId)));
    }

    private Collection<CategoryConfig> getAllCategories() {
        return this.categories.get().map(Map::values).orElseGet(Collections::emptyList);
    }

    private void syncCategory(ServerPlayer player, CategoryConfig category, CategoryData categoryData) {
        this.applyRewards(player, category, categoryData);
        this.showCategory(player, category, categoryData);
    }

    private void syncCategory(ServerPlayer player, CategoryConfig category) {
        this.getCategoryDataIfUnlocked(player, category).ifPresentOrElse(categoryData -> this.syncCategory(player, category, (CategoryData)categoryData), () -> {
            this.resetRewards(player, category);
            this.hideCategory(player, category);
        });
    }

    private void syncAllCategories(ServerPlayer player) {
        if (this.isConfigValid()) {
            Collection<CategoryConfig> categories = this.getAllCategories();
            if (categories.isEmpty()) {
                this.showToast(player, ToastType.MISSING_CONFIG);
            } else {
                for (CategoryConfig category : categories) {
                    this.syncCategory(player, category);
                }
            }
        } else {
            this.showToast(player, ToastType.INVALID_CONFIG);
        }
    }

    private void showToast(ServerPlayer player, ToastType type) {
        if (this.isOperatorOrHost(player)) {
            this.packetSender.send(player, ShowToastOutPacket.write(type));
        }
    }

    public void openScreen(ServerPlayer player, Optional<ResourceLocation> categoryId) {
        this.packetSender.send(player, OpenScreenOutPacket.write(categoryId));
    }

    private boolean isConfigValid() {
        return this.categories.get().isPresent();
    }

    private PlayerData getPlayerData(ServerPlayer player) {
        return ServerData.getOrCreate(this.getPlayerServer(player)).getPlayerData(player);
    }

    private MinecraftServer getPlayerServer(ServerPlayer player) {
        return Objects.requireNonNull(player.m_20194_());
    }

    private boolean isOperatorOrHost(ServerPlayer player) {
        MinecraftServer server = this.getPlayerServer(player);
        return server.m_7779_(player.m_36316_()) || server.m_6846_().m_11303_(player.m_36316_());
    }

    private class EventListener
    implements ServerEventListener {
        private EventListener() {
        }

        @Override
        public void onServerStarting(MinecraftServer server) {
            SkillsMod.this.loadModConfig(server);
        }

        @Override
        public void onServerReload(MinecraftServer server) {
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                for (CategoryConfig category : SkillsMod.this.getAllCategories()) {
                    SkillsMod.this.hideCategory(player, category);
                }
            }
            SkillsMod.this.loadModConfig(server);
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                SkillsMod.this.syncAllCategories(player);
            }
        }

        @Override
        public void onPlayerJoin(ServerPlayer player) {
            SkillsMod.this.syncAllCategories(player);
        }

        @Override
        public void onCommandsRegister(CommandDispatcher<CommandSourceStack> dispatcher) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"puffish_skills").then(CategoryCommand.create())).then(SkillsCommand.create())).then(PointsCommand.create())).then(ExperienceCommand.create())).then(OpenCommand.create()));
        }
    }
}

