/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.api;

import com.github.talrey.createdeco.BlockStateGenerator;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class Doors {
    public static final BlockSetType OPEN_METAL_DOOR = new BlockSetType("metal", true, SoundType.f_56743_, SoundEvents.f_12055_, SoundEvents.f_12056_, SoundEvents.f_12011_, SoundEvents.f_12012_, SoundEvents.f_12066_, SoundEvents.f_12067_, SoundEvents.f_12443_, SoundEvents.f_12444_);

    public static NonNullBiConsumer<DataGenContext<Block, DoorBlock>, RegistrateRecipeProvider> recipe(Supplier<Item> ingot) {
        return (ctx, prov) -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)3).m_126130_("mm").m_126130_("mm").m_126130_("mm").m_126127_(Character.valueOf('m'), (ItemLike)ingot.get()).m_126132_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ingot.get()})).m_176498_((Consumer)prov);
    }

    public static BlockBuilder<DoorBlock, ?> build(CreateRegistrate reg, String metal, boolean locked) {
        String regName = (locked ? "locked_" : "") + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_door";
        return (BlockBuilder)reg.block(regName, p -> new DoorBlock(p, locked ? BlockSetType.f_271208_ : OPEN_METAL_DOOR)).initialProperties(() -> Blocks.f_50166_).properties(props -> props.m_60955_().m_60913_(5.0f, 5.0f).m_60999_().m_60918_(SoundType.f_56725_)).blockstate((ctx, prov) -> BlockStateGenerator.door(reg, metal, locked, ctx, prov)).addLayer(() -> RenderType::m_110457_).loot((table, block) -> {
            LootTable.Builder builder = LootTable.m_79147_();
            LootPool.Builder pool = LootPool.m_79043_();
            pool.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.LOWER)));
            table.m_247577_((Block)block, builder.m_79161_(pool));
        }).tag(new TagKey[]{BlockTags.f_144282_}).tag(new TagKey[]{BlockTags.f_13103_}).item().model((ctx, prov) -> BlockStateGenerator.doorItem(reg, metal, ctx, prov)).properties(props -> metal.contains("Netherite") ? props.m_41486_() : props).build();
    }

    public static NonNullBiConsumer<DataGenContext<Block, DoorBlock>, RegistrateRecipeProvider> lockedRecipe(Supplier<Item> originalDoor) {
        return (ctx, prov) -> ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).m_126211_((ItemLike)Items.f_41978_, 1).m_126209_((ItemLike)originalDoor.get()).m_126132_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)originalDoor.get()})).m_176498_((Consumer)prov);
    }

    public static BlockBuilder<TrapDoorBlock, ?> buildTrapdoor(CreateRegistrate reg, String metal) {
        String regName = metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_trapdoor";
        String path = "block/palettes/doors/" + regName;
        ResourceLocation texture = new ResourceLocation("createdeco", path);
        return (BlockBuilder)reg.block(regName, p -> new TrapDoorBlock(p, OPEN_METAL_DOOR)).properties(props -> props.m_60955_().m_60913_(5.0f, 5.0f).m_60999_().m_60918_(SoundType.f_56725_)).blockstate((ctx, prov) -> prov.trapdoorBlock((TrapDoorBlock)ctx.get(), texture, true)).lang(metal + " Trapdoor").tag(new TagKey[]{BlockTags.f_144282_}).tag(new TagKey[]{BlockTags.f_13036_}).addLayer(() -> RenderType::m_110457_).item().model((ctx, prov) -> BlockStateGenerator.trapdoorItem(reg, metal, ctx, prov)).build();
    }

    public static NonNullBiConsumer<DataGenContext<Block, TrapDoorBlock>, RegistrateRecipeProvider> trapdoorRecipe(Supplier<Item> ingot) {
        return (ctx, prov) -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).m_126130_("mm").m_126130_("mm").m_126127_(Character.valueOf('m'), (ItemLike)ingot.get()).m_126132_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ingot.get()})).m_176498_((Consumer)prov);
    }
}

