/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.utility;

import com.copycatsplus.copycats.foundation.copycat.CopycatMaterialStore;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlockEntity;
import com.copycatsplus.copycats.utility.forge.BlockEntityUtilsImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockEntityUtils {
    public static void redraw(BlockEntity blockEntity) {
        Level level = blockEntity.m_58904_();
        if (level != null) {
            if (blockEntity instanceof IMultiStateCopycatBlockEntity) {
                IMultiStateCopycatBlockEntity multiStateBE = (IMultiStateCopycatBlockEntity)blockEntity;
                CopycatMaterialStore.setMaterial((BlockGetter)level, blockEntity.m_58899_(), multiStateBE.getMaterialItemStorage().getMaterialMap());
            } else if (blockEntity instanceof ICopycatBlockEntity) {
                ICopycatBlockEntity copycatBE = (ICopycatBlockEntity)blockEntity;
                CopycatMaterialStore.setMaterial((BlockGetter)level, blockEntity.m_58899_(), copycatBE.getMaterial());
            }
            if (level.m_5776_()) {
                BlockEntityUtils.requestModelDataUpdate(blockEntity);
            } else {
                blockEntity.m_6596_();
            }
            BlockState state = blockEntity.m_58900_();
            level.m_7260_(blockEntity.m_58899_(), state, state, 16);
            BlockEntityUtils.updateLight(blockEntity);
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void requestModelDataUpdate(BlockEntity blockEntity) {
        BlockEntityUtilsImpl.requestModelDataUpdate(blockEntity);
    }

    private static void updateLight(BlockEntity blockEntity) {
        Level level = blockEntity.m_58904_();
        if (level != null) {
            BlockPos pos = blockEntity.m_58899_();
            ProfilerFiller profilerFiller = level.m_46473_();
            profilerFiller.m_6180_("updateSkyLightSources");
            level.m_46865_(pos).m_284400_().m_284521_((BlockGetter)level, pos.m_123341_() & 0xF, pos.m_123342_(), pos.m_123343_() & 0xF);
            profilerFiller.m_6182_("queueCheckLight");
            level.m_7726_().m_7827_().m_7174_(pos);
            profilerFiller.m_7238_();
            level.m_46865_(pos).m_8092_(true);
        }
    }
}

