/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.compat;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.client.EntityCache;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class EntityRenderer {
    public static void render(PoseStack stack, @Nullable EntityType<?> type, int x, int y, @Nullable CompoundTag variant, Optional<CompoundTag> defaultVariant) {
        LivingEntity entity;
        if (type != null && (entity = EntityCache.fetchEntity(type, (Level)Minecraft.m_91087_().f_91073_, variant, defaultVariant)) != null) {
            int scale = 16;
            float height = entity.m_20206_();
            float width = entity.m_20205_();
            if (height <= 0.5f && width < 0.75f) {
                scale = (int)(Math.max(height, width) * 48.0f);
            } else if (height < 1.0f && width < 0.75f) {
                scale = (int)(Math.max(height, width) * 32.0f);
            } else if (height > 2.0f) {
                scale = (int)(32.0f / Math.max(height, width));
            }
            try {
                PoseStack modelView = RenderSystem.getModelViewStack();
                modelView.m_85836_();
                modelView.m_252931_(stack.m_85850_().m_252922_());
                EntityRenderer.renderTheEntity(x, y, scale, entity);
                modelView.m_85849_();
                RenderSystem.applyModelViewMatrix();
            }
            catch (Exception e) {
                OpenBlocksTrophies.LOGGER.error("Error drawing entity " + ForgeRegistries.ENTITY_TYPES.getKey(type), (Throwable)e);
                EntityCache.addEntityToBlacklist(type);
            }
        }
    }

    public static void renderTheEntity(int x, int y, int scale, LivingEntity entity) {
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        posestack.m_85837_((double)x, (double)y, 1050.0);
        EntityRenderer.applyAdditionalTransforms(entity.m_6095_(), posestack);
        posestack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack posestack1 = new PoseStack();
        posestack1.m_85837_(0.0, 0.0, 1000.0);
        if (entity instanceof EnderDragon) {
            posestack1.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            posestack1.m_252781_(Axis.f_252529_.m_252977_(-30.0f));
        }
        posestack1.m_85841_((float)scale, (float)scale, (float)scale);
        Quaternionf quaternion = Axis.f_252403_.m_252977_(180.0f);
        Quaternionf quaternion1 = Axis.f_252529_.m_252977_(20.0f);
        quaternion.mul((Quaternionfc)quaternion1);
        posestack1.m_252781_(quaternion);
        posestack1.m_252781_(Axis.f_252495_.m_252977_(35.0f));
        posestack1.m_252781_(Axis.f_252392_.m_252977_(145.0f));
        float f2 = entity.f_20883_;
        float f3 = entity.m_146908_();
        float f4 = entity.m_146909_();
        float f5 = entity.f_20886_;
        float f6 = entity.f_20885_;
        entity.f_20883_ = 0.0f;
        entity.m_146922_(0.0f);
        entity.m_146926_(0.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        Lighting.m_166384_();
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        quaternion1.conjugate();
        dispatcher.m_252923_(quaternion1);
        boolean hitboxes = dispatcher.m_114377_();
        dispatcher.m_114468_(false);
        dispatcher.m_114473_(false);
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.runAsFancy(() -> dispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, posestack1, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0));
        multibuffersource$buffersource.m_109911_();
        dispatcher.m_114468_(true);
        dispatcher.m_114473_(hitboxes);
        entity.f_20883_ = f2;
        entity.m_146922_(f3);
        entity.m_146926_(f4);
        entity.f_20886_ = f5;
        entity.f_20885_ = f6;
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
    }

    private static void applyAdditionalTransforms(EntityType<?> entity, PoseStack stack) {
        if (entity == EntityType.f_20453_) {
            stack.m_85837_(0.0, -12.5, 0.0);
            stack.m_85841_(0.5f, 0.5f, 0.5f);
        }
        if (entity == EntityType.f_20565_) {
            stack.m_85837_(0.0, -4.0, 0.0);
        }
        if (entity == EntityType.f_20496_) {
            stack.m_85837_(0.0, 8.0, 0.0);
        }
        if (entity == EntityType.f_20480_ || entity == EntityType.f_147034_) {
            stack.m_85837_(0.0, -19.0, 0.0);
        }
        if (entity == EntityType.f_20563_) {
            stack.m_85841_(0.6f, 0.6f, 0.6f);
        }
    }
}

