/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.command;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.command.CreateDisplayTrophyCommand;
import com.gizmo.trophies.command.DumpRegistryCommand;
import com.gizmo.trophies.command.GenerateTrophyStubCommand;
import com.gizmo.trophies.command.PlaceTrophiesCommand;
import com.gizmo.trophies.trophy.Trophy;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public class TrophiesCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"obtrophies").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"debug").requires(cs -> cs.m_6761_(3))).then(DumpRegistryCommand.register())).then(GenerateTrophyStubCommand.register()))).then(CreateDisplayTrophyCommand.register(context))).then(Commands.m_82127_((String)"count").executes(TrophiesCommands::count))).then(PlaceTrophiesCommand.register()));
    }

    public static List<String> getLoadedModIds() {
        ArrayList<String> modids = new ArrayList<String>();
        for (IModInfo info : ModList.get().getMods()) {
            modids.add(info.getModId());
        }
        modids.add(0, "all");
        Collections.sort(modids);
        return modids;
    }

    public static int count(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        if (Trophy.getTrophies().isEmpty()) {
            throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.obtrophies.empty_list").m_130940_(ChatFormatting.RED)).create();
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.obtrophies.count", (Object[])new Object[]{Trophy.getTrophies().size()}), false);
        return 1;
    }

    public static boolean writeToFile(JsonElement element, Path path) {
        try {
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
            HashingOutputStream hashingoutputstream = new HashingOutputStream(Hashing.sha256(), (OutputStream)bytearrayoutputstream);
            try (JsonWriter jsonwriter = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)hashingoutputstream, StandardCharsets.UTF_8));){
                jsonwriter.setSerializeNulls(false);
                jsonwriter.setIndent("  ");
                GsonHelper.m_216207_((JsonWriter)jsonwriter, (JsonElement)element, Comparator.naturalOrder());
            }
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, bytearrayoutputstream.toByteArray(), new OpenOption[0]);
                return true;
            }
        }
        catch (IOException ioexception) {
            OpenBlocksTrophies.LOGGER.error("Failed to save file to {}", (Object)path, (Object)ioexception);
        }
        return false;
    }
}

