/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.command;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.command.TrophiesCommands;
import com.gizmo.trophies.trophy.Trophy;
import com.google.gson.JsonElement;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.text.DecimalFormat;
import net.jodah.typetools.TypeResolver;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class GenerateTrophyStubCommand {
    private static final DecimalFormat FORMAT = new DecimalFormat("#.##");

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"makeTemplatesFor").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"modid", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(TrophiesCommands.getLoadedModIds(), (SuggestionsBuilder)builder)).executes(context -> GenerateTrophyStubCommand.writeTrophiesForMod((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"modid"), true, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"check_existing_trophies", (ArgumentType)BoolArgumentType.bool()).executes(context -> GenerateTrophyStubCommand.writeTrophiesForMod((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"modid"), BoolArgumentType.getBool((CommandContext)context, (String)"check_existing_trophies"), false))).then(Commands.m_82129_((String)"print_entities", (ArgumentType)BoolArgumentType.bool()).executes(context -> GenerateTrophyStubCommand.writeTrophiesForMod((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"modid"), BoolArgumentType.getBool((CommandContext)context, (String)"check_existing_trophies"), BoolArgumentType.getBool((CommandContext)context, (String)"print_entities"))))));
    }

    private static int writeTrophiesForMod(CommandContext<CommandSourceStack> context, String modid, boolean checkExistingConfigs, boolean printEachEntity) throws CommandSyntaxException {
        if (!modid.equals("all") && !ModList.get().isLoaded(modid)) {
            throw new SimpleCommandExceptionType((Message)Component.m_237110_((String)"command.obtrophies.mod_not_loaded", (Object[])new Object[]{modid}).m_130940_(ChatFormatting.RED)).create();
        }
        int successfulFilesMade = 0;
        for (EntityType entity : BuiltInRegistries.f_256780_.m_123024_().filter(type -> (modid.equals("all") || BuiltInRegistries.f_256780_.m_7981_(type).m_135827_().equals(modid)) && checkExistingConfigs != Trophy.getTrophies().containsKey(BuiltInRegistries.f_256780_.m_7981_(type))).toList()) {
            Class instance = GenerateTrophyStubCommand.getEntityClass(entity);
            if (instance == null || !Mob.class.isAssignableFrom(instance) || entity.m_20674_() == MobCategory.MISC) continue;
            ResourceLocation entityName = BuiltInRegistries.f_256780_.m_7981_((Object)entity);
            Path path = ((CommandSourceStack)context.getSource()).m_81372_().m_7654_().m_129843_(LevelResource.f_78179_).resolve(entityName.m_135827_()).resolve("trophies").resolve(entityName.m_135815_() + ".json").normalize();
            Trophy.Builder dummy = new Trophy.Builder(entity);
            if (entity.m_204039_(Tags.EntityTypes.BOSSES)) {
                dummy.setDropChance(0.0075);
            }
            if (entity.m_20679_() > 0.0f) {
                dummy.setScale(Float.parseFloat(FORMAT.format(Math.min(2.0f, 2.0f / entity.m_20679_()))));
            }
            if (!TrophiesCommands.writeToFile((JsonElement)Trophy.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)dummy.build()).resultOrPartial(arg_0 -> ((Logger)OpenBlocksTrophies.LOGGER).error(arg_0)).orElseThrow(), path)) continue;
            if (printEachEntity) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.obtrophies.trophy_made", (Object[])new Object[]{entityName.toString()}), false);
            }
            ++successfulFilesMade;
        }
        int totalFiles = successfulFilesMade;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.obtrophies.trophies_made", (Object[])new Object[]{totalFiles}), false);
        return 1;
    }

    @Nullable
    private static <T extends Entity> Class<T> getEntityClass(EntityType<T> type) {
        Class entityClass = TypeResolver.resolveRawArgument(EntityType.EntityFactory.class, type.f_20535_.getClass());
        if (entityClass == TypeResolver.Unknown.class) {
            OpenBlocksTrophies.LOGGER.error("Couldn't resolve entity class provided for entity {}", (Object)type.m_20675_());
            return null;
        }
        return entityClass;
    }
}

