/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.command;

import com.gizmo.trophies.command.TrophiesCommands;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.storage.LevelResource;

public class DumpRegistryCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"dumpRegistry").then(Commands.m_82129_((String)"registry", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((context, builder) -> SharedSuggestionProvider.m_82926_(DumpRegistryCommand.getAllRegistries(((CommandSourceStack)context.getSource()).m_81372_()), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)"dumpToFile", (ArgumentType)BoolArgumentType.bool()).executes(context -> DumpRegistryCommand.forEachRegistry((CommandContext<CommandSourceStack>)context, ResourceLocationArgument.m_107011_((CommandContext)context, (String)"registry"), BoolArgumentType.getBool((CommandContext)context, (String)"dumpToFile")))));
    }

    public static List<ResourceLocation> getAllRegistries(ServerLevel level) {
        ArrayList<ResourceLocation> registries = new ArrayList<ResourceLocation>(level.m_9598_().m_206193_().map(registryEntry -> registryEntry.f_206233_().m_135782_()).toList());
        registries.add(0, new ResourceLocation("", "all"));
        return registries;
    }

    public static int forEachRegistry(CommandContext<CommandSourceStack> context, ResourceLocation registryName, boolean dumpToFile) {
        if (registryName.toString().equals("all")) {
            DumpRegistryCommand.getAllRegistries(((CommandSourceStack)context.getSource()).m_81372_()).forEach(location -> DumpRegistryCommand.getRegistryKeys(context, location, dumpToFile));
        } else {
            DumpRegistryCommand.getRegistryKeys(context, registryName, dumpToFile);
        }
        return 1;
    }

    public static void getRegistryKeys(CommandContext<CommandSourceStack> context, ResourceLocation registryName, boolean dumpToFile) {
        ResourceKey key = ResourceKey.m_135788_((ResourceLocation)registryName);
        if (dumpToFile) {
            Path path = ((CommandSourceStack)context.getSource()).m_81372_().m_7654_().m_129843_(LevelResource.f_78179_).resolve("registries").resolve(registryName.m_135827_()).resolve(registryName.m_135815_() + ".json").normalize();
            JsonObject object = new JsonObject();
            JsonArray registryArray = new JsonArray();
            ((CommandSourceStack)context.getSource()).m_5894_().m_175515_(key).m_6579_().forEach(entry -> registryArray.add(((ResourceKey)entry.getKey()).m_135782_().toString()));
            object.add("entries", (JsonElement)registryArray);
            TrophiesCommands.writeToFile((JsonElement)object, path);
        } else {
            ((CommandSourceStack)context.getSource()).m_5894_().m_175515_(key).m_6579_().forEach(entry -> ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)((ResourceKey)entry.getKey()).m_135782_().toString())));
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Registry Size: " + ((CommandSourceStack)context.getSource()).m_5894_().m_175515_(key).m_6579_().size())));
        }
    }
}

