/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.client;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.block.TrophyBlock;
import com.gizmo.trophies.block.entity.TrophyBlockEntity;
import com.gizmo.trophies.client.ClientEvents;
import com.gizmo.trophies.client.EntityCache;
import com.gizmo.trophies.client.PlayerInfoHolder;
import com.gizmo.trophies.client.PlayerTrophyModel;
import com.gizmo.trophies.trophy.Trophy;
import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class TrophyRenderer
implements BlockEntityRenderer<TrophyBlockEntity> {
    private static final List<ResourceLocation> KEYS = new ArrayList<ResourceLocation>();
    private final PlayerTrophyModel trophy;
    private final PlayerTrophyModel slimTrophy;

    public TrophyRenderer(BlockEntityRendererProvider.Context context) {
        this.trophy = new PlayerTrophyModel(context.m_173582_(ClientEvents.PLAYER_TROPHY), false);
        this.slimTrophy = new PlayerTrophyModel(context.m_173582_(ClientEvents.SLIM_PLAYER_TROPHY), true);
    }

    public static void renderEntity(@Nullable TrophyBlockEntity be, int variant, String name, Level level, BlockPos pos, Trophy trophy, PoseStack stack, MultiBufferSource source, int light, boolean cycling, PlayerTrophyModel normalTrophy, PlayerTrophyModel slimTrophy) {
        stack.m_85836_();
        if (KEYS.isEmpty() && !Trophy.getTrophies().isEmpty()) {
            KEYS.addAll(Trophy.getTrophies().keySet().stream().filter(location -> !location.equals((Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20532_))).toList());
            Collections.shuffle(KEYS);
        }
        if (trophy.type() == EntityType.f_20532_) {
            stack.m_252880_(0.5f, 0.0f, 0.5f);
            if (be != null) {
                stack.m_252781_(Axis.f_252436_.m_252977_(-((Direction)be.m_58900_().m_61143_((Property)TrophyBlock.FACING)).m_122435_()));
            }
            if (name.equalsIgnoreCase("dinnerbone") || name.equalsIgnoreCase("grumm")) {
                stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            } else {
                stack.m_252880_(0.0f, 1.3f, 0.0f);
            }
            stack.m_85841_(0.7f, -0.7f, -0.7f);
            PlayerInfoHolder holder = PlayerInfoHolder.getSkinFromName(name.toLowerCase(Locale.ROOT));
            if (holder.slim()) {
                slimTrophy.m_7695_(stack, source.m_6299_(holder.type()), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                normalTrophy.m_7695_(stack, source.m_6299_(holder.type()), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (holder.cape() != null) {
                stack.m_85836_();
                stack.m_252880_(0.0f, 0.75f, 0.06f);
                stack.m_85841_(0.6f, 0.6f, 0.6f);
                stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                normalTrophy.m_103411_(stack, source.m_6299_(RenderType.m_110446_((ResourceLocation)holder.cape())), light, OverlayTexture.f_118083_);
                stack.m_85849_();
            }
            if (name.equalsIgnoreCase("deadmau5")) {
                for (int j = 0; j < 2; ++j) {
                    stack.m_85836_();
                    stack.m_252880_(0.275f * (float)(j * 2 - 1), 0.0f, 0.0f);
                    stack.m_252880_(0.0f, 0.475f, 0.0f);
                    normalTrophy.m_103401_(stack, source.m_6299_(holder.type()), light, OverlayTexture.f_118083_);
                    stack.m_85849_();
                }
            }
        } else {
            if (cycling && !KEYS.isEmpty()) {
                trophy = Trophy.getTrophies().get(KEYS.get((int)(Blaze3D.m_83640_() % (double)KEYS.size())));
            }
            List<CompoundTag> variants = trophy.getVariants(level.m_9598_());
            LivingEntity entity = EntityCache.fetchEntity(trophy.type(), level, variant < variants.size() ? variants.get(variant) : null, trophy.defaultData());
            if (entity != null) {
                EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
                boolean hitboxes = dispatcher.m_114377_();
                dispatcher.m_114468_(false);
                dispatcher.m_114473_(false);
                entity.m_6593_((Component)(!name.isEmpty() ? Component.m_237113_((String)name) : null));
                entity.m_20340_(false);
                entity.f_19797_ = entity instanceof Sheep && entity.m_8077_() ? (int)level.m_6106_().m_6793_() : 0;
                entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.25 + trophy.verticalOffset(), (double)pos.m_123343_() + 0.5);
                stack.m_85837_(0.5, 0.25 + trophy.verticalOffset(), 0.5);
                if (be != null) {
                    if (LocalDate.of(LocalDate.now().getYear(), 4, 1).equals(LocalDate.now())) {
                        RandomSource rand = RandomSource.m_216335_((long)pos.m_121878_());
                        if (rand.m_188503_(10) == 0) {
                            if (Minecraft.m_91087_().f_91075_ != null) {
                                Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
                                Vec3 vec3 = new Vec3(camera.m_90583_().m_7096_(), camera.m_90583_().m_7098_(), camera.m_90583_().m_7094_());
                                Vec3 vec31 = new Vec3((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 1.0f), (double)((float)pos.m_123343_() + 0.5f));
                                Vec3 vec32 = vec3.m_82546_(vec31);
                                vec32 = vec32.m_82541_();
                                float f5 = (float)Math.acos(vec32.m_7098_());
                                float f6 = (float)Math.atan2(vec32.m_7094_(), vec32.m_7096_());
                                stack.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - f6) * 57.295776f));
                                stack.m_252781_(Axis.f_252529_.m_252977_(f5 * 57.295776f - 90.0f));
                            }
                        } else {
                            stack.m_252781_(Axis.f_252436_.m_252977_((float)level.m_46467_() * 15.0f));
                        }
                    } else {
                        stack.m_252781_(Axis.f_252436_.m_252977_(-((Direction)be.m_58900_().m_61143_((Property)TrophyBlock.FACING)).m_122435_()));
                    }
                }
                if (entity instanceof EnderDragon) {
                    stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                }
                stack.m_85841_(0.4f, 0.4f, 0.4f);
                stack.m_85841_(trophy.scale(), trophy.scale(), trophy.scale());
                try {
                    dispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, stack, source, light);
                }
                catch (Exception e) {
                    OpenBlocksTrophies.LOGGER.error("Failed to render entity {} as a trophy", (Object)trophy.type().m_20675_(), (Object)e);
                    EntityCache.addEntityToBlacklist(trophy.type());
                }
                dispatcher.m_114468_(true);
                dispatcher.m_114473_(hitboxes);
            }
        }
        stack.m_85849_();
    }

    public void render(TrophyBlockEntity blockEntity, float partialTicks, PoseStack stack, MultiBufferSource source, int light, int overlay) {
        if (blockEntity.getTrophy() != null) {
            stack.m_85836_();
            if (!((Boolean)blockEntity.m_58900_().m_61143_((Property)TrophyBlock.PEDESTAL)).booleanValue()) {
                stack.m_85837_(0.0, -0.25, 0.0);
            }
            TrophyRenderer.renderEntity(blockEntity, blockEntity.getVariant(), blockEntity.getTrophyName(), blockEntity.m_58904_(), blockEntity.m_58899_(), blockEntity.getTrophy(), stack, source, light, blockEntity.isCycling(), this.trophy, this.slimTrophy);
            stack.m_85849_();
        }
    }
}

