/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.client;

import com.gizmo.trophies.OpenBlocksTrophies;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EntityCache {
    private static final Map<EntityType<?>, Entity> ENTITY_MAP = new HashMap();
    private static final Set<EntityType<?>> IGNORED_ENTITIES = new HashSet();

    @Nullable
    public static LivingEntity fetchEntity(EntityType<?> type, @Nullable Level level, @Nullable CompoundTag variant, Optional<CompoundTag> defaultVariant) {
        if (level != null && !IGNORED_ENTITIES.contains(type)) {
            LocalPlayer entity = null;
            if (type == EntityType.f_20532_) {
                entity = Minecraft.m_91087_().f_91074_;
            } else {
                try {
                    entity = ENTITY_MAP.computeIfAbsent(type, t -> {
                        Entity created = t.m_20615_(level);
                        if (created != null) {
                            created.m_146922_(0.0f);
                            created.m_5616_(0.0f);
                            created.m_5618_(0.0f);
                            created.f_19812_ = false;
                            if (created instanceof Mob) {
                                Mob mob = (Mob)created;
                                mob.m_21557_(true);
                            }
                        }
                        return created;
                    });
                }
                catch (Exception e) {
                    OpenBlocksTrophies.LOGGER.error("Failed to cache a render for entity {}", (Object)type.m_20675_(), (Object)e);
                }
            }
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                CompoundTag tag = new CompoundTag();
                defaultVariant.ifPresent(tag1 -> tag1.m_128431_().forEach(s -> tag.m_128365_(s, Objects.requireNonNull(tag1.m_128423_(s)))));
                if (variant != null) {
                    if (entity instanceof VillagerDataHolder) {
                        VillagerDataHolder villager = (VillagerDataHolder)entity;
                        variant.m_128431_().forEach(s -> villager.m_34375_(new VillagerData(VillagerType.f_35821_, Objects.requireNonNull((VillagerProfession)Minecraft.m_91087_().f_91073_.m_9598_().m_175515_(Registries.f_256749_).m_7745_(ResourceLocation.m_135820_((String)variant.m_128461_(s)))), 1)));
                    } else {
                        variant.m_128431_().forEach(s -> tag.m_128365_(s, Objects.requireNonNull(variant.m_128423_(s))));
                    }
                }
                if (!tag.m_128456_()) {
                    living.m_7378_(tag);
                    if (entity instanceof Mob) {
                        Mob mob = (Mob)entity;
                        mob.m_21557_(true);
                    }
                }
                return living;
            }
            IGNORED_ENTITIES.add(type);
            ENTITY_MAP.remove(type);
        }
        return null;
    }

    public static void addEntityToBlacklist(EntityType<?> type) {
        IGNORED_ENTITIES.add(type);
        ENTITY_MAP.remove(type);
    }
}

