/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.client;

import com.gizmo.trophies.TrophyRegistries;
import com.gizmo.trophies.client.VariantToggleButton;
import com.gizmo.trophies.item.TrophyItem;
import com.gizmo.trophies.trophy.Trophy;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.searchtree.SearchRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.CreativeModeTabSearchRegistry;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="obtrophies", value={Dist.CLIENT})
public class CreativeModeVariantToggle {
    private static CreativeModeTab lastTab = CreativeModeTabs.m_257543_();
    private static String lastSearchQuery = "";
    public static VariantToggleButton showVariants;
    private static int guiCenterX;
    private static int guiCenterY;

    @SubscribeEvent
    public static void addVariantButton(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
            guiCenterX = creativeScreen.getGuiLeft();
            guiCenterY = creativeScreen.getGuiTop();
            showVariants = new VariantToggleButton(guiCenterX + 174, guiCenterY + 3, (Component)Component.m_237113_((String)"Show variants"), false, button -> {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof CreativeModeInventoryScreen) {
                    CreativeModeInventoryScreen creative = (CreativeModeInventoryScreen)screen;
                    CreativeModeVariantToggle.updateItems(creative);
                }
            });
            event.addListener((GuiEventListener)showVariants);
            CreativeModeVariantToggle.onSwitchCreativeTab(CreativeModeInventoryScreen.f_98507_, creativeScreen);
        }
    }

    @SubscribeEvent
    public static void setupVariantButton(ScreenEvent.Render.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
            guiCenterX = creativeScreen.getGuiLeft();
            guiCenterY = creativeScreen.getGuiTop();
            CreativeModeTab tab = CreativeModeInventoryScreen.f_98507_;
            if (lastTab != tab) {
                CreativeModeVariantToggle.onSwitchCreativeTab(tab, creativeScreen);
                lastTab = tab;
            }
            if (tab == TrophyRegistries.TROPHY_TAB.get() && !creativeScreen.f_98510_.m_94155_().equals(lastSearchQuery)) {
                tab.m_269498_(CreativeModeVariantToggle.buildParams());
                lastSearchQuery = creativeScreen.f_98510_.m_94155_();
            }
        }
    }

    private static void onSwitchCreativeTab(CreativeModeTab tab, CreativeModeInventoryScreen screen) {
        if (tab == TrophyRegistries.TROPHY_TAB.get()) {
            CreativeModeVariantToggle.showVariants.f_93624_ = true;
            CreativeModeVariantToggle.updateItems(screen);
        } else {
            CreativeModeVariantToggle.showVariants.f_93624_ = false;
        }
    }

    private static void updateItems(CreativeModeInventoryScreen screen) {
        CreativeModeInventoryScreen.f_98507_.m_269498_(CreativeModeVariantToggle.buildParams());
        CreativeModeInventoryScreen.ItemPickerMenu menu = (CreativeModeInventoryScreen.ItemPickerMenu)screen.m_6262_();
        menu.f_98639_.clear();
        menu.f_98639_.addAll(CreativeModeVariantToggle.getTrophyList(Minecraft.m_91087_().f_91073_.m_9598_(), (SearchRegistry.Key<ItemStack>)CreativeModeTabSearchRegistry.getNameSearchKey((CreativeModeTab)CreativeModeInventoryScreen.f_98507_), screen.f_98510_.m_94155_()));
        menu.m_98642_(0.0f);
        screen.f_98508_ = 0.0f;
    }

    private static List<ItemStack> getTrophyList(RegistryAccess access, @Nullable SearchRegistry.Key<ItemStack> searchTree, String queriedSearch) {
        ArrayList<ItemStack> trophies = new ArrayList<ItemStack>();
        if (!Trophy.getTrophies().isEmpty()) {
            TreeMap sortedTrophies = new TreeMap(Comparator.naturalOrder());
            sortedTrophies.putAll(Trophy.getTrophies());
            for (Map.Entry trophyEntry : sortedTrophies.entrySet()) {
                if (!((Trophy)trophyEntry.getValue()).getVariants(access).isEmpty() && showVariants.isSelected()) {
                    for (int i = 0; i < ((Trophy)trophyEntry.getValue()).getVariants(access).size(); ++i) {
                        trophies.add(TrophyItem.loadEntityToTrophy(((Trophy)trophyEntry.getValue()).type(), i, false));
                    }
                    continue;
                }
                trophies.add(TrophyItem.loadEntityToTrophy(((Trophy)trophyEntry.getValue()).type(), 0, false));
            }
        }
        return searchTree != null && !queriedSearch.isEmpty() ? Minecraft.m_91087_().m_231372_(searchTree).m_6293_(queriedSearch) : trophies;
    }

    private static CreativeModeTab.ItemDisplayParameters buildParams() {
        FeatureFlagSet features = Optional.of(Minecraft.m_91087_()).map(m -> m.f_91074_).map(p -> p.f_108617_).map(ClientPacketListener::m_247016_).orElse(FeatureFlagSet.m_246902_());
        return new CreativeModeTab.ItemDisplayParameters(features, ((Boolean)Minecraft.m_91087_().f_91066_.m_257871_().m_231551_()).booleanValue(), (HolderLookup.Provider)Minecraft.m_91087_().f_91073_.m_9598_());
    }

    static {
        guiCenterX = 0;
        guiCenterY = 0;
    }
}

