/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.client;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.TrophyConfig;
import com.gizmo.trophies.TrophyRegistries;
import com.gizmo.trophies.block.TrophyBlock;
import com.gizmo.trophies.block.entity.TrophyBlockEntity;
import com.gizmo.trophies.client.DisplayTrophyRenderer;
import com.gizmo.trophies.client.PlayerInfoHolder;
import com.gizmo.trophies.client.PlayerTrophyModel;
import com.gizmo.trophies.client.TrophyRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="obtrophies", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    public static final ModelLayerLocation PLAYER_TROPHY = new ModelLayerLocation(OpenBlocksTrophies.location("player_trophy"), "main");
    public static final ModelLayerLocation SLIM_PLAYER_TROPHY = new ModelLayerLocation(OpenBlocksTrophies.location("slim_player_trophy"), "main");

    @SubscribeEvent
    public static void registerBERenderer(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)TrophyRegistries.TROPHY_BE.get(), TrophyRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TrophyRegistries.DISPLAY_TROPHY_BE.get(), DisplayTrophyRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(PLAYER_TROPHY, () -> LayerDefinition.m_171565_((MeshDefinition)PlayerTrophyModel.createMesh(false), (int)64, (int)64));
        event.registerLayerDefinition(SLIM_PLAYER_TROPHY, () -> LayerDefinition.m_171565_((MeshDefinition)PlayerTrophyModel.createMesh(true), (int)64, (int)64));
    }

    @Mod.EventBusSubscriber(modid="obtrophies", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeClientEvents {
        @SubscribeEvent
        public static void dontRenderTrophyHitbox(RenderHighlightEvent.Block event) {
            BlockState state = event.getCamera().m_90592_().m_9236_().m_8055_(event.getTarget().m_82425_());
            if (state.m_60713_((Block)TrophyRegistries.TROPHY.get()) || state.m_60713_((Block)TrophyRegistries.DISPLAY_TROPHY.get())) {
                TrophyBlockEntity trophy;
                BlockEntity blockEntity;
                if (((Boolean)TrophyConfig.CLIENT_CONFIG.playersRenderNames.get()).booleanValue() && (blockEntity = event.getCamera().m_90592_().m_9236_().m_7702_(event.getTarget().m_82425_())) instanceof TrophyBlockEntity && (trophy = (TrophyBlockEntity)blockEntity).getTrophy() != null && trophy.getTrophy().type() == EntityType.f_20532_ && !trophy.getTrophyName().isBlank()) {
                    ForgeClientEvents.renderNameTag((Component)Component.m_237113_((String)trophy.getTrophyName()), event.getCamera(), event.getTarget().m_82425_(), event.getPoseStack(), event.getMultiBufferSource(), (Boolean)state.m_61143_((Property)TrophyBlock.PEDESTAL));
                    event.setCanceled(true);
                }
                if (!((Boolean)state.m_61143_((Property)TrophyBlock.PEDESTAL)).booleanValue()) {
                    event.setCanceled(true);
                }
            }
        }

        private static void renderNameTag(Component name, Camera camera, BlockPos pos, PoseStack stack, MultiBufferSource source, boolean pedestal) {
            Vec3 vec = camera.m_90583_();
            float f = (float)((double)pos.m_123341_() - vec.m_7096_());
            float f1 = (float)((double)pos.m_123342_() - vec.m_7098_());
            float f2 = (float)((double)pos.m_123343_() - vec.m_7094_());
            int i = name.getString().equalsIgnoreCase("deadmau5") ? -10 : 0;
            float offset = pedestal ? 1.25f : 1.0f;
            name = ForgeClientEvents.handleSpecialNames(name);
            stack.m_85836_();
            stack.m_252880_(f + 0.5f, f1 + offset, f2 + 0.5f);
            stack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
            stack.m_85841_(-0.015f, -0.015f, 0.015f);
            Matrix4f matrix4f = stack.m_85850_().m_252922_();
            float opacity = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
            int j = (int)(opacity * 255.0f) << 24;
            Font font = Minecraft.m_91087_().f_91062_;
            float width = -font.m_92852_((FormattedText)name) / 2;
            font.m_272077_(name, width, (float)i, 0x20FFFFFF, false, matrix4f, source, Font.DisplayMode.NORMAL, j, 0xF000F0);
            font.m_272077_(name, width, (float)i, -1, false, matrix4f, source, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            stack.m_85849_();
        }

        private static Component handleSpecialNames(Component name) {
            Component ogName = name;
            if (ogName.getString().equalsIgnoreCase("gizmothemoonpig")) {
                name = name.m_6881_().m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)16724756)));
            }
            if (ogName.getString().equalsIgnoreCase("tomatenjaeger")) {
                name = name.m_6879_().m_7220_((Component)Component.m_237113_((String)" \u2764").m_130940_(ChatFormatting.RED));
            }
            if (((Boolean)TrophyConfig.CLIENT_CONFIG.renderNameColorsAndIcons.get()).booleanValue()) {
                if (ogName.getString().equalsIgnoreCase("celintro")) {
                    name = name.m_6879_().m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)" \u2620").m_130940_(ChatFormatting.WHITE));
                }
                if (ogName.getString().equalsIgnoreCase("fastcheeta")) {
                    name = name.m_6879_().m_130940_(ChatFormatting.DARK_PURPLE).m_7220_((Component)Component.m_237113_((String)" \ud83c\udf3c").m_130940_(ChatFormatting.LIGHT_PURPLE));
                }
                if (ogName.getString().equalsIgnoreCase("derpderpling")) {
                    name = name.m_6879_().m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)6560463)));
                }
                if (ogName.getString().equalsIgnoreCase("bigdious")) {
                    name = name.m_6879_().m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)" \u263a"));
                }
                if (ogName.getString().equalsIgnoreCase("melodioustwin")) {
                    name = name.m_6879_().m_130940_(ChatFormatting.DARK_AQUA).m_7220_((Component)Component.m_237113_((String)" \u266b"));
                }
                if (ogName.getString().equalsIgnoreCase("badneighbour")) {
                    name = name.m_6879_().m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)" \ud83d\ude97"));
                }
                if (ogName.getString().equalsIgnoreCase("jodlodi")) {
                    name = name.m_6879_().m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x992D22)));
                }
                if (ogName.getString().equalsIgnoreCase("benimatic")) {
                    name = name.m_6879_().m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)1146986)));
                }
                if (ogName.getString().equalsIgnoreCase("killer_demon")) {
                    name = name.m_6879_().m_130940_(ChatFormatting.RED);
                }
                if (ogName.getString().equalsIgnoreCase("drullkus")) {
                    name = name.m_6879_().m_130940_(ChatFormatting.GOLD);
                }
                if (ogName.getString().equalsIgnoreCase("tamaized")) {
                    name = name.m_6879_().m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)16753898)));
                }
                if (ogName.getString().equalsIgnoreCase("alphaleaf")) {
                    name = name.m_6879_().m_130940_(ChatFormatting.GREEN);
                }
                if (PlayerInfoHolder.TF_DEVS.contains(ogName.getString().toLowerCase(Locale.ROOT))) {
                    name = name.m_6881_().m_7220_((Component)Component.m_237113_((String)"\ue115").m_130940_(ChatFormatting.WHITE));
                }
                if (PlayerInfoHolder.MOJANGSTAS.contains(ogName.getString().toLowerCase(Locale.ROOT))) {
                    name = name.m_6881_().m_7220_((Component)Component.m_237113_((String)"\uf56e").m_130940_(ChatFormatting.DARK_RED));
                }
            }
            return name;
        }
    }
}

