/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.block;

import com.gizmo.trophies.TrophyRegistries;
import com.gizmo.trophies.block.AbstractTrophyBlock;
import com.gizmo.trophies.block.entity.TrophyBlockEntity;
import com.gizmo.trophies.item.TrophyItem;
import com.gizmo.trophies.trophy.AmbientSoundFetcher;
import com.gizmo.trophies.trophy.Trophy;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class TrophyBlock
extends AbstractTrophyBlock {
    private static final VoxelShape PLAYER_SHAPE = Block.m_49796_((double)5.0, (double)4.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);

    public TrophyBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        TrophyBlockEntity trophy;
        BlockEntity blockEntity = getter.m_7702_(pos);
        if (blockEntity instanceof TrophyBlockEntity && (trophy = (TrophyBlockEntity)blockEntity).getTrophy() != null && trophy.getTrophy().type() == EntityType.f_20532_) {
            return (Boolean)state.m_61143_((Property)PEDESTAL) != false ? Shapes.m_83110_((VoxelShape)PEDESTAL_SHAPE, (VoxelShape)PLAYER_SHAPE) : NO_PEDESTAL_SHAPE;
        }
        return super.m_5940_(state, getter, pos, context);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof TrophyBlockEntity) {
            TrophyBlockEntity trophyBE = (TrophyBlockEntity)be;
            Trophy trophy = TrophyItem.getTrophy(stack);
            if (trophy != null) {
                trophyBE.setTrophy(trophy);
                trophyBE.setTrophyName(stack.m_41788_() ? stack.m_41786_().getString() : "");
                CompoundTag tag = BlockItem.m_186336_((ItemStack)stack);
                if (tag != null) {
                    if (tag.m_128441_("cooldown")) {
                        trophyBE.setCooldown(tag.m_128451_("cooldown"));
                    }
                    if (tag.m_128441_("SpecialCycleVariant")) {
                        trophyBE.setCycling(tag.m_128471_("SpecialCycleVariant"));
                    }
                }
            }
        }
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        TrophyBlockEntity trophyBE;
        Trophy trophy;
        BlockEntity blockEntity;
        if (player.m_6144_()) {
            level.m_46597_(pos, (BlockState)state.m_61122_((Property)PEDESTAL));
            level.m_5594_(null, pos, SoundEvents.f_144101_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof TrophyBlockEntity && (trophy = (trophyBE = (TrophyBlockEntity)blockEntity).getTrophy()) != null) {
            if (trophy.type() == EntityType.f_20532_) {
                level.m_5594_(null, pos, (SoundEvent)TrophyRegistries.OOF.get(), SoundSource.BLOCKS, 1.0f, (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.2f + 1.0f);
            } else if (trophy.clickSoundOverride().isPresent()) {
                level.m_5594_(null, pos, trophy.clickSoundOverride().get(), SoundSource.BLOCKS, 1.0f, (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.2f + 1.0f);
            } else {
                Pair<SoundEvent, Float> soundData = AmbientSoundFetcher.getAmbientSoundAndPitch(trophy.type(), level);
                if (soundData.getFirst() != null) {
                    level.m_5594_(null, pos, (SoundEvent)soundData.getFirst(), SoundSource.BLOCKS, 1.0f, ((Float)soundData.getSecond()).floatValue());
                }
                if (trophyBE.getCooldown() <= 0 && trophy.clickBehavior().isPresent()) {
                    trophyBE.setCooldown(trophy.clickBehavior().get().execute(trophyBE, (ServerPlayer)player, player.m_21120_(hand)));
                }
            }
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        TrophyBlockEntity trophyBE;
        ArrayList<ItemStack> drop = new ArrayList<ItemStack>();
        BlockEntity blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (blockEntity instanceof TrophyBlockEntity && (trophyBE = (TrophyBlockEntity)blockEntity).getTrophy() != null) {
            ItemStack newStack = new ItemStack((ItemLike)this);
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("entity", Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(trophyBE.getTrophy().type())).toString());
            tag.m_128405_("VariantID", trophyBE.getVariant());
            if (trophyBE.getCooldown() > 0) {
                tag.m_128405_("cooldown", trophyBE.getCooldown());
            }
            if (trophyBE.isCycling()) {
                tag.m_128379_("SpecialCycleVariant", true);
            }
            newStack.m_41700_("BlockEntityTag", (Tag)tag);
            drop.add(newStack);
        }
        return drop;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter getter, BlockPos pos, Player player) {
        TrophyBlockEntity trophyBE;
        ItemStack newStack = new ItemStack((ItemLike)this);
        CompoundTag tag = new CompoundTag();
        BlockEntity blockEntity = getter.m_7702_(pos);
        if (blockEntity instanceof TrophyBlockEntity && (trophyBE = (TrophyBlockEntity)blockEntity).getTrophy() != null) {
            tag.m_128359_("entity", Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(trophyBE.getTrophy().type())).toString());
            if (trophyBE.isCycling()) {
                tag.m_128379_("SpecialCycleVariant", true);
            }
            newStack.m_41700_("BlockEntityTag", (Tag)tag);
            if (!trophyBE.getTrophyName().isEmpty()) {
                newStack.m_41714_((Component)Component.m_237113_((String)trophyBE.getTrophyName()));
            }
        }
        return newStack;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TrophyBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.m_5776_() ? null : TrophyBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TrophyRegistries.TROPHY_BE.get()), (level1, pos, state1, blockEntity) -> TrophyBlockEntity.tick(blockEntity));
    }
}

