/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.behavior;

import com.gizmo.trophies.behavior.CustomBehavior;
import com.gizmo.trophies.behavior.CustomBehaviorType;
import com.gizmo.trophies.behavior.CustomTrophyBehaviors;
import com.gizmo.trophies.block.entity.TrophyBlockEntity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public record PlaceBlockBehavior(BlockState placedBlock, PlacementMethod placement, int cooldown) implements CustomBehavior
{
    public static final Codec<PlaceBlockBehavior> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.fieldOf("block").forGetter(PlaceBlockBehavior::placedBlock), (App)PlacementMethod.CODEC.fieldOf("method").forGetter(PlaceBlockBehavior::placement), (App)Codec.INT.optionalFieldOf("cooldown", (Object)100).forGetter(PlaceBlockBehavior::cooldown)).apply((Applicative)instance, PlaceBlockBehavior::new));

    public PlaceBlockBehavior(Block block, PlacementMethod placement) {
        this(block.m_49966_(), placement, 100);
    }

    @Override
    public CustomBehaviorType getType() {
        return (CustomBehaviorType)CustomTrophyBehaviors.PLACE_BLOCK.get();
    }

    @Override
    public int execute(TrophyBlockEntity block, ServerPlayer player, ItemStack usedItem) {
        BlockPos base = block.m_58899_();
        Level level = block.m_58904_();
        if (level != null) {
            switch (this.placement()) {
                case ABOVE: {
                    this.placeBlock(level, base.m_7494_());
                    break;
                }
                case CROSS: {
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        this.placeBlock(level, base.m_121945_(direction));
                    }
                    break;
                }
                case AROUND: {
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = -1; z <= 1; ++z) {
                            this.placeBlock(level, base.m_7918_(x, 0, z));
                        }
                    }
                    break;
                }
                case ENCASE: {
                    for (int x = -1; x <= 1; ++x) {
                        for (int y = -1; y <= 1; ++y) {
                            for (int z = -1; z <= 1; ++z) {
                                this.placeBlock(level, base.m_7918_(x, y, z));
                            }
                        }
                    }
                    break;
                }
            }
        }
        return this.cooldown();
    }

    private void placeBlock(Level level, BlockPos pos) {
        if (level.m_8055_(pos).m_247087_() && this.placedBlock().m_60710_((LevelReader)level, pos)) {
            Block block = this.placedBlock().m_60734_();
            if (block instanceof SnowLayerBlock) {
                SnowLayerBlock layer = (SnowLayerBlock)block;
                int layers = level.m_213780_().m_188503_(8) + 1;
                level.m_46597_(pos, (BlockState)layer.m_49966_().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(layers)));
            } else {
                LiquidBlock liquid;
                block = this.placedBlock().m_60734_();
                if (block instanceof LiquidBlock && (liquid = (LiquidBlock)block).getFluid().getFluidType().isVaporizedOnPlacement(level, pos, null)) {
                    level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f);
                } else {
                    level.m_46597_(pos, this.placedBlock());
                }
            }
        }
    }

    public static enum PlacementMethod implements StringRepresentable
    {
        ABOVE,
        CROSS,
        AROUND,
        ENCASE;

        public static final StringRepresentable.EnumCodec<PlacementMethod> CODEC;

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.m_216439_(PlacementMethod::values);
        }
    }
}

