/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.behavior;

import com.gizmo.trophies.behavior.CustomBehavior;
import com.gizmo.trophies.behavior.CustomBehaviorType;
import com.gizmo.trophies.behavior.CustomTrophyBehaviors;
import com.gizmo.trophies.block.entity.TrophyBlockEntity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public record ItemDropBehavior(ItemStack itemToDrop, int cooldown, Optional<SoundEvent> sound) implements CustomBehavior
{
    public static final Codec<ItemDropBehavior> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.f_41582_.fieldOf("item").forGetter(ItemDropBehavior::itemToDrop), (App)Codec.INT.optionalFieldOf("cooldown", (Object)0).forGetter(ItemDropBehavior::cooldown), (App)SoundEvent.f_263124_.optionalFieldOf("sound").forGetter(ItemDropBehavior::sound)).apply((Applicative)instance, ItemDropBehavior::new));

    public ItemDropBehavior(Item itemToDrop) {
        this(new ItemStack((ItemLike)itemToDrop), 0, Optional.empty());
    }

    public ItemDropBehavior(Item itemToDrop, int cooldown) {
        this(new ItemStack((ItemLike)itemToDrop), cooldown, Optional.empty());
    }

    public ItemDropBehavior(Item itemToDrop, int cooldown, @Nullable SoundEvent sound) {
        this(new ItemStack((ItemLike)itemToDrop), cooldown, Optional.ofNullable(sound));
    }

    @Override
    public CustomBehaviorType getType() {
        return (CustomBehaviorType)CustomTrophyBehaviors.ITEM_DROP.get();
    }

    @Override
    public int execute(TrophyBlockEntity block, ServerPlayer player, ItemStack usedItem) {
        if (this.sound().isPresent()) {
            player.m_9236_().m_5594_(null, player.m_20183_(), this.sound().get(), SoundSource.BLOCKS, 1.0f, (player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.2f + 1.0f);
        }
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.itemToDrop().m_41777_());
        return this.cooldown();
    }
}

