/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.behavior;

import com.gizmo.trophies.behavior.CustomBehavior;
import com.gizmo.trophies.behavior.CustomBehaviorType;
import com.gizmo.trophies.behavior.CustomTrophyBehaviors;
import com.gizmo.trophies.block.entity.TrophyBlockEntity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public record ClickWithItemBehavior(Either<ItemStack, TagKey<Item>> ingredient, boolean consumeStack, Optional<CustomBehavior> behavior, int cooldown, Optional<SoundEvent> sound) implements CustomBehavior
{
    public static final Codec<ClickWithItemBehavior> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either((Codec)ItemStack.f_41582_, (Codec)TagKey.m_203877_((ResourceKey)Registries.f_256913_)).fieldOf("item_to_use").forGetter(ClickWithItemBehavior::ingredient), (App)Codec.BOOL.fieldOf("shrink_item_stack").forGetter(ClickWithItemBehavior::consumeStack), (App)CustomTrophyBehaviors.CODEC.optionalFieldOf("execute_behavior").forGetter(ClickWithItemBehavior::behavior), (App)Codec.INT.optionalFieldOf("cooldown", (Object)0).forGetter(ClickWithItemBehavior::cooldown), (App)SoundEvent.f_263124_.optionalFieldOf("sound").forGetter(ClickWithItemBehavior::sound)).apply((Applicative)instance, ClickWithItemBehavior::new));

    public ClickWithItemBehavior(Item clickedItem, boolean consumeStack, @Nullable CustomBehavior executeBehavior) {
        this(clickedItem, consumeStack, executeBehavior, 0, null);
    }

    public ClickWithItemBehavior(Item clickedItem, boolean consumeStack, @Nullable CustomBehavior executeBehavior, @Nullable SoundEvent sound) {
        this(clickedItem, consumeStack, executeBehavior, 0, sound);
    }

    public ClickWithItemBehavior(Item clickedItem, boolean consumeStack, @Nullable CustomBehavior executeBehavior, int cooldown, @Nullable SoundEvent sound) {
        this((Either<ItemStack, TagKey<Item>>)Either.left((Object)new ItemStack((ItemLike)clickedItem)), consumeStack, Optional.ofNullable(executeBehavior), cooldown, Optional.ofNullable(sound));
    }

    public ClickWithItemBehavior(TagKey<Item> clickedItem, boolean consumeStack, @Nullable CustomBehavior executeBehavior, int cooldown, @Nullable SoundEvent sound) {
        this((Either<ItemStack, TagKey<Item>>)Either.right(clickedItem), consumeStack, Optional.ofNullable(executeBehavior), cooldown, Optional.ofNullable(sound));
    }

    @Override
    public CustomBehaviorType getType() {
        return (CustomBehaviorType)CustomTrophyBehaviors.CLICK_WITH_ITEM.get();
    }

    @Override
    public int execute(TrophyBlockEntity block, ServerPlayer player, ItemStack usedItem) {
        boolean valid = false;
        if (this.ingredient().left().isPresent() && ItemStack.m_41656_((ItemStack)usedItem, (ItemStack)((ItemStack)this.ingredient().left().get()))) {
            valid = true;
        } else if (this.ingredient().right().isPresent() && usedItem.m_204117_((TagKey)this.ingredient().right().get())) {
            valid = true;
        }
        if (valid) {
            if (this.behavior().isPresent()) {
                this.behavior().get().execute(block, player, usedItem);
            }
            if (this.consumeStack() && !player.m_7500_()) {
                usedItem.m_41774_(1);
            }
            if (this.sound().isPresent()) {
                player.m_9236_().m_5594_(null, player.m_20183_(), this.sound().get(), SoundSource.BLOCKS, 1.0f, (player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.2f + 1.0f);
            }
            return this.cooldown();
        }
        return 0;
    }
}

