/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies;

import net.minecraftforge.common.ForgeConfigSpec;

public class TrophyConfig {
    public static ClientConfig CLIENT_CONFIG;
    public static CommonConfig COMMON_CONFIG;

    public static class CommonConfig {
        public final ForgeConfigSpec.BooleanValue fakePlayersDropTrophies;
        public final ForgeConfigSpec.BooleanValue anySourceDropsTrophies;
        public final ForgeConfigSpec.DoubleValue dropChanceOverride;
        public final ForgeConfigSpec.DoubleValue playerChargedCreeperDropChance;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            this.fakePlayersDropTrophies = builder.translation("obtrophies.config.fake_player_drops").comment("If true, fake players will allow mobs to drop trophies.\nThis can allow mob grinders from other mobs to drop trophies, such as the mob masher from MobGrindingUtils.").define("fake_player_drops", false);
            this.anySourceDropsTrophies = builder.translation("obtrophies.config.any_kill_drops").comment("If true, allows trophies to drop whenever a mob dies. This can be to fall damage, another mob, etc.\nBasically, a kill doesnt have to count as a player kill for a trophy to drop.").define("any_kill_drops", false);
            this.dropChanceOverride = builder.translation("obtrophies.config.drop_chance").comment("The chance a trophy will drop from its respective mob.\nAll trophy drop chances are defined in their trophy json, but if you want to override that chance without going through and changing every json this is for you.\nThis value works as a percentage (number * 100), so 0.2 would be a 20% chance for example.\nSet this value to any negative number to disable the override.").defineInRange("trophy_drop_override", -1.0, -1.0, 1.0);
            this.playerChargedCreeperDropChance = builder.translation("obtrophies.config.player_creeper_chance").comment("The chance a player will drop a trophy when killed by a charged creeper.\nThis config mostly exists for singleplayer worlds where getting a player kill on a player is rather difficult.\nThis value works as a percentage (number * 100), so 0.2 would be a 20% chance for example.\nSet this value to 0.0 to disable drops from charged creeper kills.").defineInRange("charged_creeper_player_trophy_chance", 0.2, 0.0, 1.0);
        }
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.BooleanValue playersRenderNames;
        public final ForgeConfigSpec.BooleanValue renderNameColorsAndIcons;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            this.playersRenderNames = builder.translation("obtrophies.config.players_render_names").comment("If true, player trophies will render their names over their head similar to how players do.").define("player_trophies_render_names", true);
            this.renderNameColorsAndIcons = builder.translation("obtrophies.config.render_name_gizmos").comment("If true, some player trophies will render with special icons or name colors.\nIf you find this to be too distracting for some reason, you can turn this off to keep the names plainly formatted.").define("render_player_trophy_name_decorators", true);
        }
    }
}

