/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.foundation.fluid;

import com.simibubi.create.AllFluids;
import com.simibubi.create.Create;
import com.simibubi.create.content.fluids.VirtualFluid;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;
import plus.dragons.createcentralkitchen.CentralKitchen;
import plus.dragons.createcentralkitchen.foundation.data.recipe.provider.Recipes;

public class VirtualFluidFromItem {
    public static final ResourceLocation WATER_STILL = new ResourceLocation("block/water_still");
    public static final ResourceLocation WATER_FLOW = new ResourceLocation("block/water_flow");
    public static final ResourceLocation MILK_STILL = Create.asResource((String)"fluid/milk_still");
    public static final ResourceLocation MILK_FLOW = Create.asResource((String)"fluid/milk_flow");

    public static FluidBuilder<VirtualFluid, CreateRegistrate> watery(String name, RegistryObject<? extends ItemLike> container, int colorIn, int amount) {
        final int color = 0xFF000000 | colorIn;
        return (FluidBuilder)CentralKitchen.REGISTRATE.virtualFluid(name, WATER_STILL, WATER_FLOW, (properties, stillTexture, flowingTexture) -> new AllFluids.TintedFluidType(properties, stillTexture, flowingTexture){

            protected int getTintColor(FluidStack stack) {
                return color;
            }

            protected int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                return color;
            }
        }, VirtualFluid::new).defaultLang().properties(builder -> builder.sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_)).transform(Recipes.fluidHandling(container, amount));
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> watery(RegistryObject<? extends ItemLike> container, int colorIn, int amount) {
        return VirtualFluidFromItem.watery(container.getId().m_135815_(), container, colorIn, amount);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> watery(String name, RegistryObject<? extends ItemLike> container, int colorIn) {
        return VirtualFluidFromItem.watery(name, container, colorIn, 250);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> watery(RegistryObject<? extends ItemLike> container, int colorIn) {
        return VirtualFluidFromItem.watery(container, colorIn, 250);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> watery(String name, ItemProviderEntry<?> container, int colorIn, int amount) {
        return (FluidBuilder)CentralKitchen.REGISTRATE.virtualFluid(name, WATER_STILL, WATER_FLOW).defaultLang().properties(builder -> builder.sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_)).transform(Recipes.fluidHandling(container, amount));
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> watery(ItemProviderEntry<?> container, int colorIn, int amount) {
        return VirtualFluidFromItem.watery(container.getId().m_135815_(), container, colorIn, amount);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> watery(String name, ItemProviderEntry<?> container, int colorIn) {
        return VirtualFluidFromItem.watery(name, container, colorIn, 250);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> watery(ItemProviderEntry<?> container, int colorIn) {
        return VirtualFluidFromItem.watery(container, colorIn, 250);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> milky(String name, RegistryObject<? extends ItemLike> container, int colorIn, int amount) {
        final int color = 0xFF000000 | colorIn;
        return (FluidBuilder)CentralKitchen.REGISTRATE.virtualFluid(name, MILK_STILL, MILK_FLOW, (properties, stillTexture, flowingTexture) -> new AllFluids.TintedFluidType(properties, stillTexture, flowingTexture){

            protected int getTintColor(FluidStack stack) {
                return color;
            }

            protected int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                return color;
            }
        }, VirtualFluid::new).defaultLang().properties(builder -> builder.sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_)).transform(Recipes.fluidHandling(container, amount));
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> milky(RegistryObject<? extends ItemLike> container, int colorIn, int amount) {
        return VirtualFluidFromItem.milky(container.getId().m_135815_(), container, colorIn, amount);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> milky(String name, RegistryObject<? extends ItemLike> container, int colorIn) {
        return VirtualFluidFromItem.milky(name, container, colorIn, 250);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> milky(RegistryObject<? extends ItemLike> container, int colorIn) {
        return VirtualFluidFromItem.milky(container, colorIn, 250);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> milky(String name, ItemProviderEntry<?> container, int colorIn, int amount) {
        final int color = 0xFF000000 | colorIn;
        return (FluidBuilder)CentralKitchen.REGISTRATE.virtualFluid(name, MILK_STILL, MILK_FLOW, (properties, stillTexture, flowingTexture) -> new AllFluids.TintedFluidType(properties, stillTexture, flowingTexture){

            protected int getTintColor(FluidStack stack) {
                return color;
            }

            protected int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                return color;
            }
        }, VirtualFluid::new).defaultLang().properties(builder -> builder.sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_)).transform(Recipes.fluidHandling(container, amount));
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> milky(ItemProviderEntry<?> container, int colorIn, int amount) {
        return VirtualFluidFromItem.milky(container.getId().m_135815_(), container, colorIn, amount);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> milky(String name, ItemProviderEntry<?> container, int colorIn) {
        return VirtualFluidFromItem.milky(name, container, colorIn, 250);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> milky(ItemProviderEntry<?> container, int colorIn) {
        return VirtualFluidFromItem.milky(container, colorIn, 250);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> virtual(String name, ResourceLocation stillTexture, ResourceLocation flowTexture, RegistryObject<? extends ItemLike> container, int amount) {
        return (FluidBuilder)CentralKitchen.REGISTRATE.virtualFluid(name, stillTexture, flowTexture).defaultLang().properties(builder -> builder.sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_)).transform(Recipes.fluidHandling(container, amount));
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> virtual(String name, ResourceLocation stillTexture, ResourceLocation flowTexture, RegistryObject<? extends ItemLike> container) {
        return VirtualFluidFromItem.virtual(name, stillTexture, flowTexture, container, 250);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> virtual(ResourceLocation stillTexture, ResourceLocation flowTexture, RegistryObject<? extends ItemLike> container, int amount) {
        String name = container.getId().m_135815_();
        return VirtualFluidFromItem.virtual(name, stillTexture, flowTexture, container, amount);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> virtual(ResourceLocation stillTexture, ResourceLocation flowTexture, RegistryObject<? extends ItemLike> container) {
        String name = container.getId().m_135815_();
        return VirtualFluidFromItem.virtual(name, stillTexture, flowTexture, container, 250);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> virtual(RegistryObject<? extends ItemLike> container, ResourceLocation texture) {
        return VirtualFluidFromItem.virtual(texture, texture, container);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> virtual(RegistryObject<? extends ItemLike> container, ResourceLocation texture, int amount) {
        return VirtualFluidFromItem.virtual(texture, texture, container, amount);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> virtual(RegistryObject<? extends ItemLike> container, int amount) {
        String name = container.getId().m_135815_();
        return VirtualFluidFromItem.virtual(name, CentralKitchen.genRL("fluid/" + name + "_still"), CentralKitchen.genRL("fluid/" + name + "_flow"), container, amount);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> virtual(RegistryObject<? extends ItemLike> container) {
        String name = container.getId().m_135815_();
        return VirtualFluidFromItem.virtual(container, 250);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> virtual(String name, ResourceLocation stillTexture, ResourceLocation flowTexture, ItemProviderEntry<?> container, int amount) {
        return (FluidBuilder)CentralKitchen.REGISTRATE.virtualFluid(name, stillTexture, flowTexture).defaultLang().properties(builder -> builder.sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_)).transform(Recipes.fluidHandling(container, amount));
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> virtual(String name, ResourceLocation stillTexture, ResourceLocation flowTexture, ItemProviderEntry<?> container) {
        return VirtualFluidFromItem.virtual(name, stillTexture, flowTexture, container, 250);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> virtual(ResourceLocation stillTexture, ResourceLocation flowTexture, ItemProviderEntry<?> container, int amount) {
        String name = container.getId().m_135815_();
        return VirtualFluidFromItem.virtual(name, stillTexture, flowTexture, container, amount);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> virtual(ResourceLocation stillTexture, ResourceLocation flowTexture, ItemProviderEntry<?> container) {
        String name = container.getId().m_135815_();
        return VirtualFluidFromItem.virtual(name, stillTexture, flowTexture, container, 250);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> virtual(ItemProviderEntry<?> container, ResourceLocation texture) {
        return VirtualFluidFromItem.virtual(texture, texture, container);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> virtual(ItemProviderEntry<?> container, ResourceLocation texture, int amount) {
        return VirtualFluidFromItem.virtual(texture, texture, container, amount);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> virtual(ItemProviderEntry<?> container, int amount) {
        String name = container.getId().m_135815_();
        return VirtualFluidFromItem.virtual(name, CentralKitchen.genRL("fluid/" + name + "_still"), CentralKitchen.genRL("fluid/" + name + "_flow"), container, amount);
    }

    public static FluidBuilder<VirtualFluid, CreateRegistrate> virtual(ItemProviderEntry<?> container) {
        String name = container.getId().m_135815_();
        return VirtualFluidFromItem.virtual(container, 250);
    }
}

