/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.content.logistics.block.mechanicalArm;

import com.simibubi.create.content.kinetics.mechanicalArm.AllArmInteractionPointTypes;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPointType;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderTagRegistry;
import com.simibubi.create.infrastructure.ponder.AllPonderTags;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createcentralkitchen.foundation.ponder.PonderArmInteractionPointType;
import vectorwing.farmersdelight.common.block.StoveBlock;
import vectorwing.farmersdelight.common.block.entity.StoveBlockEntity;

public class StovePoint
extends AllArmInteractionPointTypes.DepositOnlyArmInteractionPoint {
    public StovePoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
        super(type, level, pos, state);
    }

    protected Vec3 getInteractionPositionVector() {
        return Vec3.m_82514_((Vec3i)this.pos, (double)1.0);
    }

    public ItemStack insert(ItemStack stack, boolean simulate) {
        BlockEntity blockEntity = this.level.m_7702_(this.pos);
        if (!(blockEntity instanceof StoveBlockEntity)) {
            return stack;
        }
        StoveBlockEntity stove = (StoveBlockEntity)blockEntity;
        int slot = stove.getNextEmptySlot();
        if (slot < 0 || slot >= stove.getInventory().getSlots() || stove.isStoveBlockedAbove()) {
            return stack;
        }
        Optional recipe = stove.getMatchingRecipe((Container)new SimpleContainer(new ItemStack[]{stack}), slot);
        if (recipe.isEmpty()) {
            return stack;
        }
        ItemStack remainder = stack.m_41777_();
        if (simulate) {
            remainder.m_41774_(1);
            return remainder;
        }
        stove.addItem(remainder, (CampfireCookingRecipe)recipe.get(), slot);
        return remainder;
    }

    public static class Type
    extends PonderArmInteractionPointType {
        public Type(ResourceLocation id) {
            super(id);
        }

        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return level.m_7702_(pos) instanceof StoveBlockEntity;
        }

        @Nullable
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new StovePoint(this, level, pos, state);
        }

        @Override
        public void addToPonderTag(Consumer<ItemLike> consumer) {
            PonderTagRegistry.TagBuilder builder = PonderRegistry.TAGS.forTag(AllPonderTags.ARM_TARGETS);
            ForgeRegistries.ITEMS.getValues().stream().filter(item -> {
                BlockItem blockItem;
                return item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof StoveBlock;
            }).forEach(arg_0 -> ((PonderTagRegistry.TagBuilder)builder).add(arg_0));
        }
    }
}

