/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.utils;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.block.BlockGoldPortal;
import com.catastrophe573.dimdungeons.block.BlockPortalKeyhole;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.block.TileEntityGoldPortal;
import com.catastrophe573.dimdungeons.block.TileEntityPortalKeyhole;
import com.catastrophe573.dimdungeons.dimension.CustomTeleporter;
import com.catastrophe573.dimdungeons.item.BaseItemKey;
import com.catastrophe573.dimdungeons.item.ItemBuildKey;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.item.ItemRegistrar;
import com.catastrophe573.dimdungeons.structure.DungeonDesigner;
import com.catastrophe573.dimdungeons.structure.DungeonPlacement;
import com.catastrophe573.dimdungeons.utils.DungeonGenData;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.common.util.ITeleporter;

public class DungeonUtils {
    public static boolean isDimensionOverworld(Level worldIn) {
        return worldIn.m_46472_() == Level.f_46428_;
    }

    public static boolean isDimensionDungeon(Level worldIn) {
        if (worldIn == null) {
            return false;
        }
        return worldIn.m_46472_().m_135782_().m_135815_() == "dungeon_dimension";
    }

    public static boolean isDimensionPersonalBuild(Level worldIn) {
        if (worldIn == null) {
            return false;
        }
        return worldIn.m_46472_().m_135782_().m_135815_() == "build_dimension";
    }

    public static ServerLevel getDungeonWorld(MinecraftServer server) {
        return server.m_129880_(DimDungeons.DUNGEON_DIMENSION);
    }

    public static ServerLevel getPersonalBuildWorld(MinecraftServer server) {
        return server.m_129880_(DimDungeons.BUILD_DIMENSION);
    }

    public static int doesKeyMatchDebugCheat(DungeonGenData genData) {
        if (!(genData.keyItem.m_41720_() instanceof ItemPortalKey)) {
            DimDungeons.logMessageError("FATAL ERROR: Using a non-key item to build a dungeon? What happened?");
            return 0;
        }
        if (genData.keyItem.m_41788_() && DungeonConfig.enableDebugCheats) {
            String name = genData.keyItem.m_41786_().getString();
            if (name.contentEquals("DebugOne")) {
                return 1;
            }
            if (name.contentEquals("DebugTwo")) {
                return 2;
            }
            if (name.contentEquals("DebugThree")) {
                return 3;
            }
            if (name.contentEquals("DebugFour")) {
                return 4;
            }
            if (name.contentEquals("bas-4")) {
                return 5;
            }
            if (name.contentEquals("bas-3")) {
                return 6;
            }
            if (name.contentEquals("bas-h")) {
                return 7;
            }
            if (name.contentEquals("bas-c")) {
                return 8;
            }
            if (name.contentEquals("bas-1")) {
                return 9;
            }
            if (name.contentEquals("adv-4")) {
                return 10;
            }
            if (name.contentEquals("adv-3")) {
                return 11;
            }
            if (name.contentEquals("adv-h")) {
                return 12;
            }
            if (name.contentEquals("adv-c")) {
                return 13;
            }
            if (name.contentEquals("adv-1")) {
                return 14;
            }
            if (name.contains("theme-")) {
                return 15;
            }
        }
        return 0;
    }

    public static boolean dungeonAlreadyExistsHere(Level worldIn, long entranceX, long entranceZ) {
        ChunkPos cpos = new ChunkPos((int)entranceX / 16, (int)entranceZ / 16);
        return DungeonPlacement.wasRoomBuiltAtChunk(worldIn, cpos);
    }

    public static boolean personalPortalAlreadyExistsHere(Level worldIn, long entranceX, long entranceZ) {
        ChunkPos cpos;
        BlockPos bpos;
        ServerLevel buildDim = DungeonUtils.getPersonalBuildWorld(worldIn.m_7654_());
        BlockState block = buildDim.m_8055_(bpos = new BlockPos((int)((float)(cpos = new ChunkPos((int)entranceX / 16 + 4, (int)entranceZ / 16 + 4)).m_45604_() + 64.0f), 50, (int)((float)cpos.m_45605_() + 128.0f)));
        return block.m_60734_() == Blocks.f_50752_;
    }

    public static void openPortalAfterBuild(Level worldIn, BlockPos pos, DungeonGenData genData, TileEntityPortalKeyhole myEntity) {
        if (!worldIn.f_46443_) {
            Player player;
            BlockState state = worldIn.m_8055_(pos);
            BaseItemKey key = (BaseItemKey)genData.keyItem.m_41720_();
            Direction keyholeFacing = (Direction)state.m_61143_((Property)BlockPortalKeyhole.FACING);
            float entranceX = key.getWarpX(genData.keyItem);
            float entranceZ = key.getWarpZ(genData.keyItem);
            boolean dungeonExistsHere = false;
            dungeonExistsHere = key instanceof ItemBuildKey ? DungeonUtils.reprogramPersonalPortal(worldIn, (long)entranceX, (long)entranceZ, genData, keyholeFacing) : (genData.dungeonType == DungeonDesigner.DungeonType.TELEPORTER_HUB ? DungeonUtils.reprogramTeleporterHubDoorway(worldIn, (long)entranceX, (long)entranceZ, genData, keyholeFacing, false) : DungeonUtils.reprogramExistingExitDoorway(worldIn, (long)entranceX, (long)entranceZ, genData, keyholeFacing));
            if (BlockPortalKeyhole.isOkayToSpawnPortalBlocks(worldIn, pos, state, myEntity) && dungeonExistsHere) {
                Direction.Axis axis = keyholeFacing == Direction.NORTH || keyholeFacing == Direction.SOUTH ? Direction.Axis.X : Direction.Axis.Z;
                BlockPortalKeyhole.addGoldenPortalBlock(worldIn, pos.m_7495_(), genData.keyItem, axis);
                BlockPortalKeyhole.addGoldenPortalBlock(worldIn, pos.m_6625_(2), genData.keyItem, axis);
            }
            if ((player = worldIn.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), -1.0, false)) != null) {
                BlockPortalKeyhole.checkForProblemsAndLiterallySpeakToPlayer(worldIn, pos, state, myEntity, player, dungeonExistsHere);
            }
        }
    }

    public static boolean reprogramExistingExitDoorway(Level worldIn, long entranceX, long entranceZ, DungeonGenData genData, Direction keyholeFacing) {
        ServerLevel dim = DungeonUtils.getDungeonWorld(worldIn.m_7654_());
        BlockPos portalStart = new BlockPos((int)entranceX, 55, (int)(entranceZ + 2L));
        return DungeonUtils.actuallyReprogramGoldPortalBlocks(portalStart, (Level)dim, genData, keyholeFacing);
    }

    public static boolean reprogramPersonalPortal(Level worldIn, long entranceX, long entranceZ, DungeonGenData genData, Direction keyholeFacing) {
        ServerLevel dim = DungeonUtils.getPersonalBuildWorld(worldIn.m_7654_());
        BlockPos portalStart = new BlockPos((int)(entranceX + 1L), 51, (int)(entranceZ + 1L));
        if (genData.returnDimension.equals(DimDungeons.BUILD_DIMENSION.m_135782_().toString())) {
            return false;
        }
        return DungeonUtils.actuallyReprogramGoldPortalBlocks(portalStart, (Level)dim, genData, keyholeFacing);
    }

    public static boolean reprogramTeleporterHubDoorway(Level worldIn, long entranceX, long entranceZ, DungeonGenData genData, Direction keyholeFacing, boolean erasePortal) {
        ServerLevel dim = DungeonUtils.getDungeonWorld(worldIn.m_7654_());
        BlockPos portalStart = new BlockPos((int)entranceX, 55, (int)entranceZ);
        int[] undo_x_offset = new int[]{0, -16, -21, -21, -16, 0, 5, 5};
        int[] undo_z_offset = new int[]{0, 0, -5, -21, -26, -26, -21, -5};
        int[] x_offset = new int[]{0, -16, -23, -23, -16, 0, 6, 6};
        int[] z_offset = new int[]{-2, -2, -6, -22, -25, -25, -22, -6};
        int doornum = genData.dungeonTheme;
        portalStart = portalStart.m_122025_(undo_x_offset[doornum]).m_122030_(x_offset[doornum]);
        portalStart = portalStart.m_122020_(undo_z_offset[doornum]).m_122013_(z_offset[doornum]);
        for (int xz = 0; xz < 2; ++xz) {
            for (int y = 0; y < 3; ++y) {
                BlockPos nextBlock = portalStart;
                Direction.Axis face = Direction.Axis.X;
                if (doornum == 0 || doornum == 1 || doornum == 4 || doornum == 5) {
                    nextBlock = nextBlock.m_122025_(xz).m_6630_(y);
                } else {
                    nextBlock = nextBlock.m_122013_(xz).m_6630_(y);
                    face = Direction.Axis.Z;
                }
                if (erasePortal) {
                    dim.m_7731_(nextBlock, Blocks.f_50016_.m_49966_(), 2);
                    continue;
                }
                dim.m_7731_(nextBlock, (BlockState)((Block)BlockRegistrar.BLOCK_GOLD_PORTAL.get()).m_49966_().m_61124_(BlockGoldPortal.AXIS, (Comparable)face), 2);
                TileEntityGoldPortal te = (TileEntityGoldPortal)dim.m_7702_(nextBlock);
                if (te != null) {
                    te.setDestination(genData.returnPoint.m_123341_(), genData.returnPoint.m_123342_(), genData.returnPoint.m_123343_(), genData.returnDimension, keyholeFacing);
                    DimDungeons.logMessageInfo("DIMDUNGEONS INFO: Reprogrammed exit door at (" + nextBlock.m_123341_() + ", " + nextBlock.m_123342_() + ", " + nextBlock.m_123343_() + ") in dim " + dim.m_46472_().m_135782_().m_135815_());
                    continue;
                }
                DimDungeons.logMessageWarn("DIMDUNGEONS WARNING: why is there no exit portal here? (" + nextBlock.m_123341_() + ", " + nextBlock.m_123342_() + ", " + nextBlock.m_123343_() + ")");
            }
        }
        return true;
    }

    protected static boolean actuallyReprogramGoldPortalBlocks(BlockPos bottomLeft, Level dim, DungeonGenData genData, Direction keyholeFacing) {
        for (int z = 0; z < 2; ++z) {
            for (int y = 0; y < 3; ++y) {
                BlockPos pos = bottomLeft.m_122025_(z).m_6630_(y);
                TileEntityGoldPortal te = (TileEntityGoldPortal)dim.m_7702_(pos);
                if (te == null) {
                    DimDungeons.logMessageWarn("DIMDUNGEONS WARNING: why is there no exit portal here? (" + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_() + ")");
                    return false;
                }
                te.setDestination(genData.returnPoint.m_123341_(), genData.returnPoint.m_123342_(), genData.returnPoint.m_123343_(), genData.returnDimension, keyholeFacing);
                DimDungeons.logMessageInfo("DIMDUNGEONS INFO: Reprogrammed exit door at (" + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_() + ") in dim " + dim.m_46472_().m_135782_().m_135815_());
            }
        }
        return true;
    }

    public static void buildSuperflatPersonalSpace(long buildX, long buildZ, MinecraftServer server) {
        BlockState[] layers = new BlockState[]{Blocks.f_50440_.m_49966_(), Blocks.f_50493_.m_49966_(), Blocks.f_50493_.m_49966_(), Blocks.f_50493_.m_49966_(), Blocks.f_50069_.m_49966_(), Blocks.f_50069_.m_49966_(), Blocks.f_152550_.m_49966_(), Blocks.f_152550_.m_49966_()};
        ServerLevel dim = DungeonUtils.getPersonalBuildWorld(server);
        ChunkPos cpos = new ChunkPos((int)buildX / 16 + 4, (int)buildZ / 16 + 4);
        BlockPos bpos = new BlockPos(cpos.m_45604_(), 50, cpos.m_45605_());
        for (int y = 0; y < 8; ++y) {
            BoundingBox pArea = new BoundingBox(bpos.m_123341_(), 50 - y, bpos.m_123343_(), bpos.m_123341_() + 128 - 1, 50 - y, bpos.m_123343_() + 128 - 1);
            for (BlockPos blockpos : BlockPos.m_121976_((int)pArea.m_162395_(), (int)pArea.m_162396_(), (int)pArea.m_162398_(), (int)pArea.m_162399_(), (int)pArea.m_162400_(), (int)pArea.m_162401_())) {
                dim.m_7731_(blockpos, layers[y], 2);
            }
        }
        BlockPos portalStart = new BlockPos((int)((float)cpos.m_45604_() + 64.0f), 50, (int)((float)cpos.m_45605_() + 128.0f));
        dim.m_7731_(portalStart, Blocks.f_50752_.m_49966_(), 2);
        dim.m_7731_(portalStart.m_122029_(), Blocks.f_50752_.m_49966_(), 2);
        dim.m_7731_(portalStart.m_122024_(), Blocks.f_50752_.m_49966_(), 2);
        dim.m_7731_(portalStart.m_122030_(2), Blocks.f_50752_.m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_122024_(), Blocks.f_50752_.m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_(), Blocks.f_50752_.m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_122029_(), Blocks.f_50752_.m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_122030_(2), Blocks.f_50752_.m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_122024_().m_7494_(), Blocks.f_50222_.m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_122030_(2).m_7494_(), Blocks.f_50222_.m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_122024_().m_6630_(2), Blocks.f_50222_.m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_122030_(2).m_6630_(2), Blocks.f_50222_.m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_122024_().m_6630_(3), Blocks.f_50222_.m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_122030_(2).m_6630_(3), Blocks.f_50222_.m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_122024_().m_6630_(4), ((Block)BlockRegistrar.BLOCK_GILDED_PORTAL.get()).m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_122030_(2).m_6630_(4), ((Block)BlockRegistrar.BLOCK_GILDED_PORTAL.get()).m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_6630_(4), Blocks.f_50222_.m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_122029_().m_6630_(4), Blocks.f_50222_.m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_122025_(3), Blocks.f_50752_.m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_122030_(4), Blocks.f_50752_.m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_122025_(3).m_7494_(), Blocks.f_50222_.m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_122030_(4).m_7494_(), Blocks.f_50222_.m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_122025_(3).m_6630_(2), Blocks.f_50222_.m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_122030_(4).m_6630_(2), Blocks.f_50222_.m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_122025_(3).m_6630_(3), ((Block)BlockRegistrar.BLOCK_GILDED_PORTAL.get()).m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_122030_(4).m_6630_(3), ((Block)BlockRegistrar.BLOCK_GILDED_PORTAL.get()).m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_7494_(), ((Block)BlockRegistrar.BLOCK_GOLD_PORTAL.get()).m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_122029_().m_7494_(), ((Block)BlockRegistrar.BLOCK_GOLD_PORTAL.get()).m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_6630_(2), ((Block)BlockRegistrar.BLOCK_GOLD_PORTAL.get()).m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_122029_().m_6630_(2), ((Block)BlockRegistrar.BLOCK_GOLD_PORTAL.get()).m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_6630_(3), ((Block)BlockRegistrar.BLOCK_GOLD_PORTAL.get()).m_49966_(), 2);
        dim.m_7731_(portalStart.m_122019_().m_122029_().m_6630_(3), ((Block)BlockRegistrar.BLOCK_GOLD_PORTAL.get()).m_49966_(), 2);
    }

    public static String serializeDimensionKey(ResourceKey<Level> dimension) {
        return dimension.m_135782_().m_135827_() + ":" + dimension.m_135782_().m_135815_();
    }

    public static long getLimitOfWorldBorder(MinecraftServer server) {
        ResourceKey configkey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(DungeonConfig.worldborderToRespect));
        ServerLevel world = server.m_129880_(configkey);
        double size = world.m_6857_().m_61959_() / 2.0;
        return Math.round(size);
    }

    public static long getLimitOfPersonalBuildDimension(MinecraftServer server) {
        ServerLevel world = DungeonUtils.getPersonalBuildWorld(server);
        double size = world.m_6857_().m_61959_() / 2.0;
        return Math.round(size);
    }

    public static boolean isPersonalBuildChunk(BlockPos pos) {
        ChunkPos chunk = new ChunkPos(pos);
        if (chunk.f_45578_ < 4 || chunk.f_45579_ < 4) {
            return false;
        }
        int nx = (chunk.f_45578_ - 4) % 32;
        int nz = (chunk.f_45579_ - 4) % 32;
        return nx < 8 && nz < 8;
    }

    public static void sendEntityHomeInBuildWorld(Entity entity) {
        double topLeftX = Math.floor(entity.m_20182_().f_82479_ / 512.0);
        topLeftX = topLeftX * 512.0 + 136.0;
        double topLeftZ = Math.floor(entity.m_20182_().f_82481_ / 512.0);
        topLeftZ = topLeftZ * 512.0 + 188.5;
        ServerLevel dim = DungeonUtils.getPersonalBuildWorld(entity.m_20194_());
        CustomTeleporter tele = new CustomTeleporter(dim);
        tele.setDestPos(topLeftX - 7.0, 51.0, topLeftZ + 4.0, 180.0f, 0.0f);
        entity.m_183634_();
        entity.changeDimension(dim, (ITeleporter)tele);
    }

    public static ItemStack getExampleKey() {
        ItemStack icon = new ItemStack((ItemLike)ItemRegistrar.ITEM_PORTAL_KEY.get());
        CompoundTag data = new CompoundTag();
        data.m_128379_("key_activated", true);
        data.m_128359_("dungeon_type", DungeonDesigner.DungeonType.BASIC.toString());
        data.m_128405_("dest_z", 0);
        data.m_128405_("name_type", 2);
        data.m_128405_("name_part_1", 0);
        data.m_128405_("name_part_2", 17);
        icon.m_41751_(data);
        return icon;
    }

    public static ItemStack getExampleBuildKey() {
        ItemStack icon = new ItemStack((ItemLike)ItemRegistrar.ITEM_BUILD_KEY.get());
        CompoundTag data = new CompoundTag();
        data.m_128379_("key_activated", true);
        icon.m_41751_(data);
        return icon;
    }

    public static ItemStack getExampleTeleporterHubKey() {
        ItemStack icon = new ItemStack((ItemLike)ItemRegistrar.ITEM_PORTAL_KEY.get());
        CompoundTag data = new CompoundTag();
        data.m_128379_("key_activated", true);
        data.m_128359_("dungeon_type", DungeonDesigner.DungeonType.TELEPORTER_HUB.toString());
        data.m_128405_("name_type", 4);
        data.m_128405_("name_part_1", 0);
        icon.m_41751_(data);
        return icon;
    }

    public static void giveSecuritySystemPrompt(Player playerIn, String transkey) {
        MutableComponent text1 = Component.m_237115_((String)Component.m_237115_((String)transkey).getString());
        text1.m_130948_(text1.m_7383_().m_131155_(Boolean.valueOf(true)));
        text1.m_130948_(text1.m_7383_().m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE)));
        playerIn.m_5661_((Component)text1, false);
    }

    public static void displayGuestList(Player playerIn, ArrayList<String> guestList) {
        MutableComponent text1 = Component.m_237115_((String)Component.m_237115_((String)"security.dimdungeons.use_book").getString());
        for (int i = 0; i < guestList.size(); ++i) {
            if (i != 0) {
                text1.m_130946_(", ");
            }
            text1.m_130946_(guestList.get(i));
        }
        text1.m_130948_(text1.m_7383_().m_131155_(Boolean.valueOf(true)));
        text1.m_130948_(text1.m_7383_().m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE)));
        playerIn.m_5661_((Component)text1, false);
    }

    public static void notifyGuestListChange(Player playerIn, String transkey, String playerName) {
        MutableComponent text1 = Component.m_237115_((String)playerName);
        text1.m_130946_(Component.m_237115_((String)transkey).getString());
        text1.m_130948_(text1.m_7383_().m_131155_(Boolean.valueOf(true)));
        text1.m_130948_(text1.m_7383_().m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE)));
        playerIn.m_5661_((Component)text1, false);
    }
}

