/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons;

import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.PlayerDungeonEvents;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.dimension.DungeonChunkGenerator;
import com.catastrophe573.dimdungeons.item.ItemBlankThemeKey;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.item.ItemRegistrar;
import com.catastrophe573.dimdungeons.item.ItemSecretBell;
import com.catastrophe573.dimdungeons.utils.CommandDimDungeons;
import com.catastrophe573.dimdungeons.utils.LootModifierNoDrops;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="dimdungeons")
public class DimDungeons {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "dimdungeons";
    public static final String RESOURCE_PREFIX = "dimdungeons:";
    public static final String dungeon_dimension_regname = "dungeon_dimension";
    public static final String build_dimension_regname = "build_dimension";
    public static final ResourceKey<Level> DUNGEON_DIMENSION = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("dimdungeons", "dungeon_dimension"));
    public static final ResourceKey<Level> BUILD_DIMENSION = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("dimdungeons", "build_dimension"));
    private static final DeferredRegister<Codec<? extends ChunkGenerator>> CHUNK_GENERATORS = DeferredRegister.create((ResourceKey)Registries.f_256783_, (String)"dimdungeons");
    public static final RegistryObject<Codec<? extends ChunkGenerator>> MY_CHUNK_GEN = CHUNK_GENERATORS.register("dimdungeons_chunkgen", () -> DungeonChunkGenerator.CODEC);
    public static final PlayerDungeonEvents eventHandler = new PlayerDungeonEvents();
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> GLM_REGISTRAR = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"dimdungeons");
    public static final RegistryObject<Codec<LootModifierNoDrops>> NO_DUNGEON_DROPS = GLM_REGISTRAR.register("no_dungeon_drops", LootModifierNoDrops.CODEC);

    public DimDungeons() {
        BlockRegistrar.register();
        ItemRegistrar.register();
        CHUNK_GENERATORS.register(FMLJavaModLoadingContext.get().getModEventBus());
        GLM_REGISTRAR.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doCommonStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::modConfig);
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        MinecraftForge.EVENT_BUS.addListener(PlayerDungeonEvents::onWorldTick);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)DungeonConfig.SERVER_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)DungeonConfig.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DungeonConfig.COMMON_SPEC, "dimdungeons-common-r190.toml");
    }

    private void doCommonStuff(FMLCommonSetupEvent event) {
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistrar.BLOCK_GOLD_PORTAL.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistrar.BLOCK_LOCAL_TELEPORTER.get()), (RenderType)RenderType.m_110466_());
            ItemProperties.register((Item)((Item)ItemRegistrar.ITEM_PORTAL_KEY.get()), (ResourceLocation)new ResourceLocation(MOD_ID, "keytype"), (stack, world, entity, number) -> ItemPortalKey.getKeyLevelAsFloat(stack));
            ItemProperties.register((Item)((Item)ItemRegistrar.ITEM_PORTAL_KEY.get()), (ResourceLocation)new ResourceLocation(MOD_ID, "keytheme"), (stack, world, entity, number) -> ItemPortalKey.getKeyThemeAsFloat(stack));
            ItemProperties.register((Item)((Item)ItemRegistrar.ITEM_BLANK_THEME_KEY.get()), (ResourceLocation)new ResourceLocation(MOD_ID, "keytheme"), (stack, world, entity, number) -> ItemBlankThemeKey.getKeyThemeAsFloat(stack));
            ItemProperties.register((Item)((Item)ItemRegistrar.ITEM_SECRET_BELL.get()), (ResourceLocation)new ResourceLocation(MOD_ID, "bellupgrade"), (stack, world, entity, number) -> ItemSecretBell.getUpgradeLevelAsFloat(stack));
            ItemProperties.register((Item)((Item)ItemRegistrar.ITEM_SECRET_BELL.get()), (ResourceLocation)new ResourceLocation(MOD_ID, "bellupgrade"), (stack, world, entity, number) -> ItemSecretBell.getUpgradeLevelAsFloat(stack));
        });
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDimDungeons.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    public void modConfig(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == DungeonConfig.CLIENT_SPEC) {
            DungeonConfig.refreshClient();
        } else if (config.getSpec() == DungeonConfig.SERVER_SPEC) {
            DungeonConfig.refreshServer();
        }
    }

    public static void logMessageInfo(String message) {
        if (DungeonConfig.logLevel.equalsIgnoreCase("all") || DungeonConfig.logLevel.equalsIgnoreCase("info")) {
            LOGGER.info(message);
        }
    }

    public static void logMessageWarn(String message) {
        if (DungeonConfig.logLevel.equalsIgnoreCase("all") || DungeonConfig.logLevel.equalsIgnoreCase("info") || DungeonConfig.logLevel.equalsIgnoreCase("warn")) {
            LOGGER.warn(message);
        }
    }

    public static void logMessageError(String message) {
        LOGGER.error(message);
    }
}

