/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class WickpiercerSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;

    public WickpiercerSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            float damageModifier = Config.getFloat("flickerFuryDamage", "UniqueEffects", ConfigDefaultValues.flickerFuryDamage);
            HelperMethods.playHitSounds(attacker, target);
            ServerLevel world = (ServerLevel)attacker.m_9236_();
            DamageSource damageSource = world.m_269111_().m_269264_();
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                damageSource = attacker.m_269291_().m_269075_(player);
            }
            if (attacker.m_21023_((MobEffect)EffectRegistry.FRENZY.get())) {
                target.f_19802_ = 0;
                target.m_6469_(damageSource, this.m_43299_() * damageModifier);
                world.m_5594_(null, attacker.m_20183_(), (SoundEvent)SoundRegistry.SPELL_FIRE.get(), attacker.m_5720_(), 0.2f, 1.9f);
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        int baseEffectDuration;
        int skillCooldown = (int)Config.getFloat("flickerFuryCooldown", "UniqueEffects", ConfigDefaultValues.flickerFuryCooldown);
        int effectDuration = baseEffectDuration = (int)Config.getFloat("flickerFuryDuration", "UniqueEffects", ConfigDefaultValues.flickerFuryDuration);
        ItemStack mainhand = user.m_21205_();
        ItemStack offhand = user.m_21206_();
        if (mainhand.m_150930_((Item)this) && offhand.m_150930_((Item)this)) {
            effectDuration = baseEffectDuration * 2;
        }
        world.m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.SPELL_FIRE.get(), user.m_5720_(), 0.5f, 1.0f);
        user.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.FRENZY.get(), effectDuration, 0));
        user.m_36335_().m_41524_((Item)this, skillCooldown);
        return super.m_7203_(world, user, hand);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123790_, ParticleTypes.f_123790_, ParticleTypes.f_123790_, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.wickpiercersworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.waxweaversworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.waxweaversworditem.tooltip5").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.waxweaversworditem.tooltip6").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.waxweaversworditem.tooltip7").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.waxweaversworditem.tooltip8").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237110_((String)"item.simplyswords.waxweaversworditem.tooltip9", (Object[])new Object[]{Float.valueOf(Config.getFloat("waxweaveCooldown", "UniqueEffects", ConfigDefaultValues.waxweaveCooldown) / 20.0f)}).m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(RIGHTCLICK));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.wickpiercersworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.wickpiercersworditem.tooltip3").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.wickpiercersworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.wickpiercersworditem.tooltip5").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237110_((String)"item.simplyswords.wickpiercersworditem.tooltip6", (Object[])new Object[]{Float.valueOf(Config.getFloat("flickerFuryDuration", "UniqueEffects", ConfigDefaultValues.flickerFuryDuration) / 20.0f)}).m_6270_(TEXT));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

