/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class SoulPyreSwordItem
extends UniqueSwordItem {
    private int relocationTimer;
    private static int stepMod = 0;
    private final int relocationDuration = (int)Config.getFloat("soultetherDuration", "UniqueEffects", ConfigDefaultValues.soultetherDuration);
    private boolean canRelocate;
    private LivingEntity relocateTarget;
    private double relocateX;
    private double relocateY;
    private double relocateZ;

    public SoulPyreSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            HelperMethods.playHitSounds(attacker, target);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (!user.m_9236_().m_5776_()) {
            int range = (int)Config.getFloat("soultetherRange", "UniqueEffects", ConfigDefaultValues.soultetherRange);
            int radius = (int)Config.getFloat("soultetherRadius", "UniqueEffects", ConfigDefaultValues.soultetherRadius);
            int ignite_duration = (int)(Config.getFloat("soultetherIgniteDuration", "UniqueEffects", ConfigDefaultValues.soultetherIgniteDuration) / 20.0f);
            int resistance_duration = (int)Config.getFloat("soultetherResistanceDuration", "UniqueEffects", ConfigDefaultValues.soultetherResistanceDuration);
            LivingEntity target = (LivingEntity)HelperMethods.getTargetedEntity((Entity)user, range);
            if (target != null && HelperMethods.checkFriendlyFire(target, (LivingEntity)user)) {
                this.relocateX = user.m_20185_();
                this.relocateY = user.m_20186_();
                this.relocateZ = user.m_20189_();
                this.relocateTarget = target;
                double rememberx = target.m_20185_();
                double remembery = target.m_20186_();
                double rememberz = target.m_20189_();
                target.m_20984_(user.m_20185_(), user.m_20186_(), user.m_20189_(), true);
                user.m_20984_(rememberx, remembery, rememberz, true);
                world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_SCIFI_ATTACK_01.get(), user.m_5720_(), 0.3f, 1.0f);
                user.m_147207_(new MobEffectInstance(MobEffects.f_19606_, resistance_duration, 0), (Entity)user);
                user.m_147207_(new MobEffectInstance(MobEffects.f_19607_, resistance_duration, 0), (Entity)user);
                user.m_147207_(new MobEffectInstance(MobEffects.f_19598_, this.relocationDuration, 3), (Entity)user);
                target.m_147207_(new MobEffectInstance((MobEffect)EffectRegistry.FREEZE.get(), this.relocationDuration - 10, 0), (Entity)user);
                this.canRelocate = true;
                this.relocationTimer = this.relocationDuration;
                AABB box = new AABB(rememberx + (double)radius, remembery + (double)radius, rememberz + (double)radius, rememberx - (double)radius, remembery - (double)radius, rememberz - (double)radius);
                for (Entity entity : world.m_6249_((Entity)user, box, EntitySelector.f_20403_)) {
                    LivingEntity le;
                    if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, (LivingEntity)user)) continue;
                    le.m_20334_((rememberx - le.m_20185_()) / 4.0, (remembery - le.m_20186_()) / 4.0, (rememberz - le.m_20189_()) / 4.0);
                    le.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 40, 3), (Entity)user);
                    world.m_6269_(null, (Entity)le, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_03.get(), le.m_5720_(), 0.1f, 3.0f);
                    le.m_20254_(ignite_duration);
                }
                user.m_36335_().m_41524_((Item)this, this.relocationDuration);
            }
        }
        return super.m_7203_(world, user, hand);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!world.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            if (this.canRelocate) {
                --this.relocationTimer;
                if (this.relocationTimer <= 0) {
                    if (this.relocateTarget != null) {
                        this.relocateTarget.m_20984_(player.m_20185_(), player.m_20186_(), player.m_20189_(), true);
                    }
                    player.m_20984_(this.relocateX, this.relocateY, this.relocateZ, true);
                    world.m_6269_(null, (Entity)player, (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_SCIFI_ATTACK_03.get(), player.m_5720_(), 0.3f, 1.0f);
                    this.canRelocate = false;
                } else if (this.relocationTimer == 40) {
                    world.m_6269_(null, (Entity)player, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_RECHARGE.get(), player.m_5720_(), 0.3f, 0.4f);
                }
            }
        }
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123745_, ParticleTypes.f_123745_, ParticleTypes.f_123757_, true);
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_175834_, ParticleTypes.f_175834_, ParticleTypes.f_123757_, false);
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123762_, ParticleTypes.f_123762_, ParticleTypes.f_123757_, false);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.soulpyresworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(RIGHTCLICK));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.soulpyresworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.soulpyresworditem.tooltip3").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.soulpyresworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.soulpyresworditem.tooltip5").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.soulpyresworditem.tooltip6").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237110_((String)"item.simplyswords.soulpyresworditem.tooltip7", (Object[])new Object[]{this.relocationDuration / 20}).m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.soulpyresworditem.tooltip8").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.soulpyresworditem.tooltip9").m_6270_(TEXT));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

