/*
 * Decompiled with CFR 0.152.
 */
package com.dragonfight.config;

import com.cupboard.config.ICommonConfig;
import com.dragonfight.config.ConfigurationCache;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public class CommonConfiguration
implements ICommonConfig {
    public int dragonDifficulty = 2;
    public boolean printDragonPhases = false;
    public boolean disableDragonAreaSpawns = true;
    public List<String> spawnoncrystaldestroy = Lists.newArrayList((Object[])new String[]{"minecraft:phantom"});
    public List<String> spawnoncrystalrespawn = Lists.newArrayList((Object[])new String[]{"minecraft:blaze"});
    public List<String> spawnwhilelanded = Lists.newArrayList((Object[])new String[]{"minecraft:enderman"});
    public double crystalRespawnTimeModifier = 1.0;
    public double lightningExplosionDensity = 1.0;
    public boolean disableLightning = false;
    public boolean antiflightAbility = true;
    public double dragonHealthModifier = 1.0;
    public double dragonDamageModifier = 1.0;
    public double mobSpawnAmountModifier = 1.0;
    public double dragonXPModifier = 1.0;

    public JsonObject serialize() {
        JsonObject root = new JsonObject();
        JsonObject entry = new JsonObject();
        entry.addProperty("desc:", "Sets the dragon difficulty modifier, the higher the more difficult the dragon gets.Scales up mob spawn amount, dragon damage and health aswell as crystal respawn intervals. Note that the difficulty already scales on the playercount involved in the fight, this is a static bonus ontop.default:2, vanilla:0");
        entry.addProperty("dragonDifficulty", (Number)this.dragonDifficulty);
        root.add("dragonDifficulty", (JsonElement)entry);
        JsonObject entry8 = new JsonObject();
        entry8.addProperty("desc:", "Modifies crystal respawn time, 0.5 = spawns twice as fast, 2 = twice as slow. default:1.0");
        entry8.addProperty("crystalRespawnTimeModifier", (Number)this.crystalRespawnTimeModifier);
        root.add("crystalRespawnTimeModifier", (JsonElement)entry8);
        JsonObject entry9 = new JsonObject();
        entry9.addProperty("desc:", "Modifies lightning and explosion density, 0.5 = half as many, 2 = twice as many. default:1.0");
        entry9.addProperty("lightningExplosionDensity", (Number)this.lightningExplosionDensity);
        root.add("lightningExplosionDensity", (JsonElement)entry9);
        JsonObject entry10 = new JsonObject();
        entry10.addProperty("desc:", "Disables lightning spawns: default:false");
        entry10.addProperty("disableLightning", Boolean.valueOf(this.disableLightning));
        root.add("disableLightning", (JsonElement)entry10);
        JsonObject entry15 = new JsonObject();
        entry15.addProperty("desc:", "Enables anti-flight ability: default:true");
        entry15.addProperty("antiflightAbility", Boolean.valueOf(this.antiflightAbility));
        root.add("antiflightAbility", (JsonElement)entry15);
        JsonObject entry16 = new JsonObject();
        entry16.addProperty("desc:", "Sets the dragon health modifier: default:1.0");
        entry16.addProperty("dragonHealthModifier", (Number)this.dragonHealthModifier);
        root.add("dragonHealthModifier", (JsonElement)entry16);
        JsonObject entry17 = new JsonObject();
        entry17.addProperty("desc:", "Sets the dragon damage modifier: default:1.0");
        entry17.addProperty("dragonDamageModifier", (Number)this.dragonDamageModifier);
        root.add("dragonDamageModifier", (JsonElement)entry17);
        JsonObject entry18 = new JsonObject();
        entry18.addProperty("desc:", "Sets the mob spawn amount modifier: default:1.0");
        entry18.addProperty("mobSpawnAmountModifier", (Number)this.mobSpawnAmountModifier);
        root.add("mobSpawnAmountModifier", (JsonElement)entry18);
        JsonObject entry20 = new JsonObject();
        entry20.addProperty("desc:", "Sets the XP drop modifier: default:1.0");
        entry20.addProperty("dragonXPModifier", (Number)this.dragonXPModifier);
        root.add("dragonXPModifier", (JsonElement)entry20);
        JsonObject entry2 = new JsonObject();
        entry2.addProperty("desc:", "Prints the dragon phase in chat if enabled: default:false");
        entry2.addProperty("printDragonPhases", Boolean.valueOf(this.printDragonPhases));
        root.add("printDragonPhases", (JsonElement)entry2);
        JsonObject entry3 = new JsonObject();
        entry3.addProperty("desc:", "Disables mob spawning on the Dragon island during the fight: default:true");
        entry3.addProperty("disableDragonAreaSpawns", Boolean.valueOf(this.disableDragonAreaSpawns));
        root.add("disableDragonAreaSpawns", (JsonElement)entry3);
        root.addProperty("descSpawnEntries", "Below are configuration options for entity spawning, when trying to use nbt append it right after the entity type, e.g. minecraft:zombie{}. Put a backslash in front of all quotation marks");
        JsonObject entry4 = new JsonObject();
        entry4.addProperty("desc:", "List of mobs spawning when a crystal is destroyed at range, intended to be flying or ranged to close the gap: e.g. format :  [\"minecraft:zombie\", \"minecraft:creeper\"]");
        JsonArray list4 = new JsonArray();
        for (String name : this.spawnoncrystaldestroy) {
            list4.add(name);
        }
        entry4.add("spawnoncrystaldestroy", (JsonElement)list4);
        root.add("spawnoncrystaldestroy", (JsonElement)entry4);
        JsonObject entry5 = new JsonObject();
        entry5.addProperty("desc:", "List of mobs spawning on crystal respawn, intended to be ranged to ward of players from a distance: e.g. format :  [\"minecraft:zombie\", \"minecraft:creeper\"]");
        JsonArray list5 = new JsonArray();
        for (String name : this.spawnoncrystalrespawn) {
            list5.add(name);
        }
        entry5.add("spawnoncrystalrespawn", (JsonElement)list5);
        root.add("spawnoncrystalrespawn", (JsonElement)entry5);
        JsonObject entry6 = new JsonObject();
        entry6.addProperty("desc:", "List of mobs spawning while the dragon is sitting in the middle, intended to be melee and not vulnerable to ranged: e.g. format :  [\"minecraft:zombie\", \"minecraft:creeper\"]");
        JsonArray list6 = new JsonArray();
        for (String name : this.spawnwhilelanded) {
            list6.add(name);
        }
        entry6.add("spawnwhilelanded", (JsonElement)list6);
        root.add("spawnwhilelanded", (JsonElement)entry6);
        return root;
    }

    public void deserialize(JsonObject data) {
        this.dragonDifficulty = data.get("dragonDifficulty").getAsJsonObject().get("dragonDifficulty").getAsInt();
        this.crystalRespawnTimeModifier = data.get("crystalRespawnTimeModifier").getAsJsonObject().get("crystalRespawnTimeModifier").getAsDouble();
        this.lightningExplosionDensity = data.get("lightningExplosionDensity").getAsJsonObject().get("lightningExplosionDensity").getAsDouble();
        this.dragonHealthModifier = data.get("dragonHealthModifier").getAsJsonObject().get("dragonHealthModifier").getAsDouble();
        this.dragonDamageModifier = data.get("dragonDamageModifier").getAsJsonObject().get("dragonDamageModifier").getAsDouble();
        this.dragonXPModifier = data.get("dragonXPModifier").getAsJsonObject().get("dragonXPModifier").getAsDouble();
        this.mobSpawnAmountModifier = data.get("mobSpawnAmountModifier").getAsJsonObject().get("mobSpawnAmountModifier").getAsDouble();
        this.printDragonPhases = data.get("printDragonPhases").getAsJsonObject().get("printDragonPhases").getAsBoolean();
        this.antiflightAbility = data.get("antiflightAbility").getAsJsonObject().get("antiflightAbility").getAsBoolean();
        this.disableLightning = data.get("disableLightning").getAsJsonObject().get("disableLightning").getAsBoolean();
        this.disableDragonAreaSpawns = data.get("disableDragonAreaSpawns").getAsJsonObject().get("disableDragonAreaSpawns").getAsBoolean();
        this.spawnoncrystaldestroy = new ArrayList<String>();
        for (JsonElement element : data.get("spawnoncrystaldestroy").getAsJsonObject().get("spawnoncrystaldestroy").getAsJsonArray()) {
            this.spawnoncrystaldestroy.add(element.getAsString());
        }
        this.spawnoncrystalrespawn = new ArrayList<String>();
        for (JsonElement element : data.get("spawnoncrystalrespawn").getAsJsonObject().get("spawnoncrystalrespawn").getAsJsonArray()) {
            this.spawnoncrystalrespawn.add(element.getAsString());
        }
        this.spawnwhilelanded = new ArrayList<String>();
        for (JsonElement element : data.get("spawnwhilelanded").getAsJsonObject().get("spawnwhilelanded").getAsJsonArray()) {
            this.spawnwhilelanded.add(element.getAsString());
        }
        ConfigurationCache.onConfigChanged();
    }
}

