/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content;

import com.simibubi.create.foundation.utility.Couple;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class BlockStressDefaults {
    public static final Map<ResourceLocation, Double> DEFAULT_IMPACTS = new ConcurrentHashMap<ResourceLocation, Double>();
    public static final Map<ResourceLocation, Double> DEFAULT_CAPACITIES = new ConcurrentHashMap<ResourceLocation, Double>();
    public static final Map<ResourceLocation, Supplier<Couple<Integer>>> GENERATOR_SPEEDS = new ConcurrentHashMap<ResourceLocation, Supplier<Couple<Integer>>>();

    public static void setDefaultImpact(ResourceLocation blockId, double impact) {
        DEFAULT_IMPACTS.put(blockId, impact);
        com.simibubi.create.content.kinetics.BlockStressDefaults.setDefaultImpact((ResourceLocation)blockId, (double)impact);
    }

    public static void setDefaultCapacity(ResourceLocation blockId, double capacity) {
        DEFAULT_CAPACITIES.put(blockId, capacity);
        com.simibubi.create.content.kinetics.BlockStressDefaults.setDefaultCapacity((ResourceLocation)blockId, (double)capacity);
    }

    public static void setGeneratorSpeed(ResourceLocation blockId, Supplier<Couple<Integer>> provider) {
        GENERATOR_SPEEDS.put(blockId, provider);
        com.simibubi.create.content.kinetics.BlockStressDefaults.setGeneratorSpeed((ResourceLocation)blockId, provider);
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setNoImpact() {
        return BlockStressDefaults.setImpact(0.0);
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setImpact(double impact) {
        return b -> {
            BlockStressDefaults.setDefaultImpact(new ResourceLocation(b.getOwner().getModid(), b.getName()), impact);
            return b;
        };
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setCapacity(double capacity) {
        return b -> {
            BlockStressDefaults.setDefaultCapacity(new ResourceLocation(b.getOwner().getModid(), b.getName()), capacity);
            return b;
        };
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setGeneratorSpeed(Supplier<Couple<Integer>> provider) {
        return b -> {
            BlockStressDefaults.setGeneratorSpeed(new ResourceLocation(b.getOwner().getModid(), b.getName()), provider);
            return b;
        };
    }
}

