/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith;

import com.cerbon.bosses_of_mass_destruction.entity.ai.action.IActionWithCooldown;
import com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith.RiftBurst;
import com.cerbon.bosses_of_mass_destruction.packet.BMDPacketHandler;
import com.cerbon.bosses_of_mass_destruction.packet.custom.SendDeltaMovementS2CPacket;
import com.cerbon.bosses_of_mass_destruction.particle.BMDParticles;
import com.cerbon.bosses_of_mass_destruction.sound.BMDSounds;
import com.cerbon.bosses_of_mass_destruction.util.BMDUtils;
import com.cerbon.cerbons_api.api.general.event.EventScheduler;
import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.static_utilities.MathUtils;
import com.cerbon.cerbons_api.api.static_utilities.SoundUtils;
import com.cerbon.cerbons_api.capability.CerbonsApiCapabilities;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WaveAction
implements IActionWithCooldown {
    private final Mob entity;
    private final List<Vec3> circlePoints;
    private final Level level;
    private final EventScheduler eventScheduler;
    private final double riftRadius = 4.0;
    public static final int waveDelay = 20;
    public static final int attackStartDelay = 20;

    public WaveAction(Mob entity) {
        this.entity = entity;
        this.circlePoints = MathUtils.buildBlockCircle((double)4.0);
        this.level = entity.m_9236_();
        this.eventScheduler = CerbonsApiCapabilities.getLevelEventScheduler((Level)this.level);
    }

    @Override
    public int perform() {
        LivingEntity target = this.entity.m_5448_();
        this.placeRifts(target);
        return 80;
    }

    private void placeRifts(LivingEntity target) {
        RiftBurst riftBurst = new RiftBurst((LivingEntity)this.entity, (ServerLevel)this.level, (ParticleOptions)BMDParticles.OBSIDILITH_WAVE_INDICATOR.get(), (ParticleOptions)BMDParticles.OBSIDILITH_WAVE.get(), 20, this.eventScheduler, this::damageEntity);
        SoundUtils.playSound((ServerLevel)((ServerLevel)this.level), (Vec3)this.entity.m_20182_(), (SoundEvent)((SoundEvent)BMDSounds.OBSIDILITH_PREPARE_ATTACK.get()), (SoundSource)SoundSource.HOSTILE, (float)3.0f, (float)0.8f, (double)64.0, null);
        this.eventScheduler.addEvent((IEvent)new TimedEvent(() -> {
            Vec3 direction = MathUtils.unNormedDirection((Vec3)this.entity.m_20182_(), (Vec3)target.m_20182_()).m_82541_().m_82490_(4.0);
            int numRifts = 5;
            Vec3 startRiftPos = this.entity.m_20182_().m_82549_(direction);
            Vec3 endRiftPos = startRiftPos.m_82549_(direction.m_82490_((double)numRifts * 1.5));
            MathUtils.lineCallback((Vec3)startRiftPos, (Vec3)endRiftPos, (int)numRifts, (linePos, i) -> this.eventScheduler.addEvent((IEvent)new TimedEvent(() -> {
                SoundUtils.playSound((ServerLevel)((ServerLevel)this.level), (Vec3)linePos, (SoundEvent)((SoundEvent)BMDSounds.WAVE_INDICATOR.get()), (SoundSource)SoundSource.HOSTILE, (float)0.7f, (double)32.0, null);
                this.eventScheduler.addEvent((IEvent)new TimedEvent(() -> SoundUtils.playSound((ServerLevel)((ServerLevel)this.level), (Vec3)linePos, (SoundEvent)((SoundEvent)BMDSounds.OBSIDILITH_WAVE.get()), (SoundSource)SoundSource.HOSTILE, (float)1.2f, (double)32.0, null), 20, 1, () -> !this.entity.m_6084_()));
                for (Vec3 point : this.circlePoints) {
                    riftBurst.tryPlaceRift(linePos.m_82549_(point));
                }
            }, i * 8, 1, () -> !this.entity.m_6084_())));
        }, 20, 1, () -> !this.entity.m_6084_()));
    }

    private void damageEntity(LivingEntity livingEntity) {
        float damage = (float)this.entity.m_21133_(Attributes.f_22281_);
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            BMDPacketHandler.sendToPlayer(new SendDeltaMovementS2CPacket(new Vec3(livingEntity.m_20184_().f_82479_, 0.8, livingEntity.m_20184_().f_82481_)), serverPlayer);
        }
        livingEntity.m_20254_(5);
        livingEntity.m_6469_(BMDUtils.shieldPiercing(livingEntity.m_9236_(), (Entity)this.entity), damage);
    }
}

