/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.createstuffadditions.network;

import java.util.function.Supplier;
import net.mcreator.createstuffadditions.CreateSaMod;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CreateSaModVariables {
    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CreateSaMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "create_sa_mapvars";
        public double db_y = 0.0;
        public double db_z = 0.0;
        public double db_x = 0.0;
        public boolean CsaFlying = false;
        public double brassJetpackMaxHeight = 28.0;
        public double andesiteJetpackMaxHeight = 18.0;
        public double copperJetpackMaxHeight = 18.0;
        public double netheriteJetpackMaxHeight = 28.0;
        public boolean enableAboveCloudEnchant = false;
        public double brassJetpackSpeed = 0.06;
        public double andesiteJetpackSpeed = 0.08;
        public double copperJetpackSpeed = 0.02;
        public double netheriteJetpackSpeed = 0.08;
        public double grapplinWhiskSpeed = 0.2;
        public double gadgetCapacity = 1600.0;
        public double smallTankCapacity = 800.0;
        public double mediumTankCapacity = 1600.0;
        public double largeTankCapacity = 3200.0;
        public boolean enableDiggingEnchant = true;
        public boolean enableImpactEnchant = true;
        public boolean enableGravityGunEnchant = true;
        public boolean enableHellfireEnchant = true;
        public boolean enableDrillDroneModule = true;
        public boolean enableFanDroneModule = true;
        public boolean enableMagnetDroneModule = true;
        public boolean enableVaultDroneModule = true;
        public boolean MagnetModuleBlockLimitation = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.db_y = nbt.m_128459_("db_y");
            this.db_z = nbt.m_128459_("db_z");
            this.db_x = nbt.m_128459_("db_x");
            this.CsaFlying = nbt.m_128471_("CsaFlying");
            this.brassJetpackMaxHeight = nbt.m_128459_("brassJetpackMaxHeight");
            this.andesiteJetpackMaxHeight = nbt.m_128459_("andesiteJetpackMaxHeight");
            this.copperJetpackMaxHeight = nbt.m_128459_("copperJetpackMaxHeight");
            this.netheriteJetpackMaxHeight = nbt.m_128459_("netheriteJetpackMaxHeight");
            this.enableAboveCloudEnchant = nbt.m_128471_("enableAboveCloudEnchant");
            this.brassJetpackSpeed = nbt.m_128459_("brassJetpackSpeed");
            this.andesiteJetpackSpeed = nbt.m_128459_("andesiteJetpackSpeed");
            this.copperJetpackSpeed = nbt.m_128459_("copperJetpackSpeed");
            this.netheriteJetpackSpeed = nbt.m_128459_("netheriteJetpackSpeed");
            this.grapplinWhiskSpeed = nbt.m_128459_("grapplinWhiskSpeed");
            this.gadgetCapacity = nbt.m_128459_("gadgetCapacity");
            this.smallTankCapacity = nbt.m_128459_("smallTankCapacity");
            this.mediumTankCapacity = nbt.m_128459_("mediumTankCapacity");
            this.largeTankCapacity = nbt.m_128459_("largeTankCapacity");
            this.enableDiggingEnchant = nbt.m_128471_("enableDiggingEnchant");
            this.enableImpactEnchant = nbt.m_128471_("enableImpactEnchant");
            this.enableGravityGunEnchant = nbt.m_128471_("enableGravityGunEnchant");
            this.enableHellfireEnchant = nbt.m_128471_("enableHellfireEnchant");
            this.enableDrillDroneModule = nbt.m_128471_("enableDrillDroneModule");
            this.enableFanDroneModule = nbt.m_128471_("enableFanDroneModule");
            this.enableMagnetDroneModule = nbt.m_128471_("enableMagnetDroneModule");
            this.enableVaultDroneModule = nbt.m_128471_("enableVaultDroneModule");
            this.MagnetModuleBlockLimitation = nbt.m_128471_("MagnetModuleBlockLimitation");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("db_y", this.db_y);
            nbt.m_128347_("db_z", this.db_z);
            nbt.m_128347_("db_x", this.db_x);
            nbt.m_128379_("CsaFlying", this.CsaFlying);
            nbt.m_128347_("brassJetpackMaxHeight", this.brassJetpackMaxHeight);
            nbt.m_128347_("andesiteJetpackMaxHeight", this.andesiteJetpackMaxHeight);
            nbt.m_128347_("copperJetpackMaxHeight", this.copperJetpackMaxHeight);
            nbt.m_128347_("netheriteJetpackMaxHeight", this.netheriteJetpackMaxHeight);
            nbt.m_128379_("enableAboveCloudEnchant", this.enableAboveCloudEnchant);
            nbt.m_128347_("brassJetpackSpeed", this.brassJetpackSpeed);
            nbt.m_128347_("andesiteJetpackSpeed", this.andesiteJetpackSpeed);
            nbt.m_128347_("copperJetpackSpeed", this.copperJetpackSpeed);
            nbt.m_128347_("netheriteJetpackSpeed", this.netheriteJetpackSpeed);
            nbt.m_128347_("grapplinWhiskSpeed", this.grapplinWhiskSpeed);
            nbt.m_128347_("gadgetCapacity", this.gadgetCapacity);
            nbt.m_128347_("smallTankCapacity", this.smallTankCapacity);
            nbt.m_128347_("mediumTankCapacity", this.mediumTankCapacity);
            nbt.m_128347_("largeTankCapacity", this.largeTankCapacity);
            nbt.m_128379_("enableDiggingEnchant", this.enableDiggingEnchant);
            nbt.m_128379_("enableImpactEnchant", this.enableImpactEnchant);
            nbt.m_128379_("enableGravityGunEnchant", this.enableGravityGunEnchant);
            nbt.m_128379_("enableHellfireEnchant", this.enableHellfireEnchant);
            nbt.m_128379_("enableDrillDroneModule", this.enableDrillDroneModule);
            nbt.m_128379_("enableFanDroneModule", this.enableFanDroneModule);
            nbt.m_128379_("enableMagnetDroneModule", this.enableMagnetDroneModule);
            nbt.m_128379_("enableVaultDroneModule", this.enableVaultDroneModule);
            nbt.m_128379_("MagnetModuleBlockLimitation", this.MagnetModuleBlockLimitation);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                CreateSaMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "create_sa_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                CreateSaMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    CreateSaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    CreateSaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                CreateSaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

