/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.entity.custom;

import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.Animation;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.hoglin.HoglinBase;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.veroxuniverse.samurai_dynasty.entity.custom.goals.KitsuneAttackGoal;
import net.veroxuniverse.samurai_dynasty.entity.variant.KitsuneVariant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KitsuneEntity
extends Monster
implements GeoEntity {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(KitsuneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public KitsuneEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22283_, (double)0.3f).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new KitsuneAttackGoal((PathfinderMob)this, 1.2, true));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public KitsuneVariant getVariant() {
        return KitsuneVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    private void setVariant(KitsuneVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        KitsuneVariant variant = (KitsuneVariant)((Object)Util.m_214670_((Object[])KitsuneVariant.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)pCompound.m_128451_("Variant"));
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Variant", this.getTypeVariant());
    }

    public int m_21304_() {
        return 18;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "move_controller", 5, state -> {
            if (state.isMoving() && !this.f_20911_) {
                state.setAnimation(RawAnimation.begin().then("animation.kitsune.walk", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            if (!state.isMoving() && !this.f_20911_) {
                state.setAnimation(RawAnimation.begin().then("animation.kitsune.idle", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attack_controller", 5, state -> {
            if (this.f_20911_) {
                state.setAnimation(RawAnimation.begin().then("animation.kitsune.attack", Animation.LoopType.PLAY_ONCE));
                return PlayState.CONTINUE;
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        })});
    }

    static boolean hurtAndThrowTarget(LivingEntity pKitsune, LivingEntity pTarget) {
        float f1 = (float)pKitsune.m_21133_(Attributes.f_22281_);
        float f = (int)f1 > 0 ? f1 / 2.0f + (float)pKitsune.m_9236_().f_46441_.m_188503_((int)f1) : f1;
        boolean flag = pTarget.m_6469_(pTarget.m_269291_().m_269333_(pKitsune), f);
        if (flag) {
            pKitsune.m_19970_(pKitsune, (Entity)pTarget);
            HoglinBase.m_34645_((LivingEntity)pKitsune, (LivingEntity)pTarget);
        }
        return flag;
    }

    public boolean m_7327_(@NotNull Entity pEntity) {
        if (!(pEntity instanceof LivingEntity)) {
            return false;
        }
        this.m_5496_(SoundEvents.f_11945_, 1.0f, 0.4f);
        return KitsuneEntity.hurtAndThrowTarget((LivingEntity)this, (LivingEntity)pEntity);
    }

    public int m_5792_() {
        return 6;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11944_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return SoundEvents.f_11948_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11946_;
    }

    protected float m_6121_() {
        return 0.5f;
    }

    public float m_6100_() {
        return 0.5f;
    }
}

